/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class RollbackCommand
extends BaseCommand {
    private static final RollbackCommand singleton = new RollbackCommand();

    public static Command getCommand() {
        return singleton;
    }

    private RollbackCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        TXId txId;
        TXManagerImpl txMgr;
        block13: {
            servConn.setAsTrue(2);
            txMgr = (TXManagerImpl)servConn.getCache().getCacheTransactionManager();
            InternalDistributedMember client = (InternalDistributedMember)servConn.getProxyID().getDistributedMember();
            int uniqId = msg.getTransactionId();
            txId = new TXId(client, uniqId);
            if (txMgr.isHostedTxRecentlyCompleted(txId) && logger.isDebugEnabled()) {
                logger.debug("TX: found a recently rolled back tx: {}", txId);
                this.sendRollbackReply(msg, servConn);
                txMgr.removeHostedTXState(txId);
                return;
            }
            TXStateProxy txState = txMgr.getTXState();
            try {
                if (txState != null) {
                    txId = txState.getTxId();
                    txMgr.rollback();
                    this.sendRollbackReply(msg, servConn);
                }
                if (!logger.isDebugEnabled()) break block13;
            }
            catch (Exception e) {
                block14: {
                    try {
                        RollbackCommand.writeException(msg, e, false, servConn);
                        servConn.setAsTrue(1);
                        if (!logger.isDebugEnabled()) break block14;
                    }
                    catch (Throwable throwable) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("TX: removing tx state for {}", txId);
                        }
                        if (txId != null) {
                            TXStateProxy proxy = txMgr.removeHostedTXState(txId);
                            if (logger.isDebugEnabled()) {
                                logger.debug("TX: removed tx state proxy {}", proxy);
                            }
                        }
                        throw throwable;
                    }
                    logger.debug("TX: removing tx state for {}", txId);
                }
                if (txId != null) {
                    TXStateProxy proxy = txMgr.removeHostedTXState(txId);
                    if (logger.isDebugEnabled()) {
                        logger.debug("TX: removed tx state proxy {}", proxy);
                    }
                }
            }
            logger.debug("TX: removing tx state for {}", txId);
        }
        if (txId != null) {
            TXStateProxy proxy = txMgr.removeHostedTXState(txId);
            if (logger.isDebugEnabled()) {
                logger.debug("TX: removed tx state proxy {}", proxy);
            }
        }
    }

    private void sendRollbackReply(Message msg, ServerConnection servConn) throws IOException {
        this.writeReply(msg, servConn);
        servConn.setAsTrue(1);
    }
}

