/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.ha.HAContainerWrapper;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientUpdateMessageImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.HAEventWrapper;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;

public class RequestEventValue
extends BaseCommand {
    private static final RequestEventValue singleton = new RequestEventValue();

    public static Command getCommand() {
        return singleton;
    }

    private RequestEventValue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        Part eventIDPart = null;
        Part valuePart = null;
        EventID event = null;
        Object callbackArg = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        StringBuffer errMessage = new StringBuffer();
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                ((GemFireCacheImpl)servConn.getCachedRegionHelper().getCache()).getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        int parts = msg.getNumberOfParts();
        eventIDPart = msg.getPart(0);
        if (eventIDPart == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.RequestEventValue_0_THE_EVENT_ID_FOR_THE_GET_EVENT_VALUE_REQUEST_IS_NULL, servConn.getName()));
            errMessage.append(" The event id for the get event value request is null.");
            RequestEventValue.writeErrorResponse(msg, 3, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            CacheClientNotifier ccn;
            HAContainerWrapper haContainer;
            try {
                event = (EventID)eventIDPart.getObject();
            }
            catch (Exception e) {
                RequestEventValue.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            if (parts > 1) {
                valuePart = msg.getPart(1);
                try {
                    if (valuePart != null) {
                        callbackArg = valuePart.getObject();
                    }
                }
                catch (Exception e) {
                    RequestEventValue.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{}: Received get event value request ({} bytes) from {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString());
            }
            if ((haContainer = (HAContainerWrapper)(ccn = servConn.getAcceptor().getCacheClientNotifier()).getHaContainer()) == null) {
                String reason = " was not found during get event value request";
                RequestEventValue.writeRegionDestroyedEx(msg, "ha container", reason, servConn);
                servConn.setAsTrue(1);
            } else {
                Object data;
                Object[] valueAndIsObject = new Object[2];
                try {
                    Object val;
                    data = haContainer.get(new HAEventWrapper(event));
                    if (data == null) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.RequestEventValue_UNABLE_TO_FIND_A_CLIENT_UPDATE_MESSAGE_FOR_0, event));
                        String msgStr = "No value found for " + event + " in " + haContainer.getName();
                        RequestEventValue.writeErrorResponse(msg, 69, msgStr, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Value retrieved for event {}", event);
                    }
                    if (!((val = ((ClientUpdateMessageImpl)data).getValueToConflate()) instanceof byte[])) {
                        val = val instanceof CachedDeserializable ? (Object)((CachedDeserializable)val).getSerializedValue() : (Object)CacheServerHelper.serialize(val);
                        ((ClientUpdateMessageImpl)data).setLatestValue(val);
                    }
                    valueAndIsObject[0] = val;
                    valueAndIsObject[1] = ((ClientUpdateMessageImpl)data).valueIsObject();
                }
                catch (Exception e) {
                    RequestEventValue.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                data = valueAndIsObject[0];
                boolean isObject = (Boolean)valueAndIsObject[1];
                RequestEventValue.writeResponse(data, callbackArg, msg, isObject, servConn);
                servConn.setAsTrue(1);
                ccn.getClientProxy(servConn.getProxyID()).getStatistics().incDeltaFullMessagesSent();
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Wrote get event value response back to {} for ha container {}", servConn.getName(), servConn.getSocketString(), haContainer.getName());
                }
            }
        }
    }
}

