/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.operations.RegisterInterestOperationContext;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.List;

public class RegisterInterestList66
extends BaseCommand {
    private static final RegisterInterestList66 singleton = new RegisterInterestList66();

    public static Command getCommand() {
        return singleton;
    }

    private RegisterInterestList66() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        byte[] regionDataPolicyPartBytes;
        InterestResultPolicy policy;
        Part regionNamePart = null;
        Object keyPart = null;
        String regionName = null;
        Object key2 = null;
        List keys = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        int numberOfKeys = 0;
        int partNumber = 0;
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        ChunkedMessage chunkedResponseMsg = servConn.getRegisterInterestResponseMessage();
        regionNamePart = msg.getPart(0);
        regionName = regionNamePart.getString();
        try {
            policy = (InterestResultPolicy)msg.getPart(1).getObject();
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean isDurable = false;
        try {
            Part durablePart = msg.getPart(2);
            byte[] durablePartBytes = (byte[])durablePart.getObject();
            isDurable = durablePartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean serializeValues = false;
        try {
            Part regionDataPolicyPart = msg.getPart(msg.getNumberOfParts() - 1);
            regionDataPolicyPartBytes = (byte[])regionDataPolicyPart.getObject();
            if (servConn.getClientVersion().compareTo(Version.GFE_80) >= 0) {
                serializeValues = regionDataPolicyPartBytes[1] == 1;
            }
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        partNumber = 3;
        Part list = msg.getPart(partNumber);
        try {
            keys = (List)list.getObject();
            numberOfKeys = keys.size();
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        boolean sendUpdatesAsInvalidates = false;
        try {
            Part notifyPart = msg.getPart(partNumber + 1);
            byte[] notifyPartBytes = (byte[])notifyPart.getObject();
            sendUpdatesAsInvalidates = notifyPartBytes[0] == 1;
        }
        catch (Exception e) {
            RegisterInterestList66.writeChunkedException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register interest 66 request ({} bytes) from {} for the following {} keys in region {}: {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), numberOfKeys, regionName, keys);
        }
        if (keys.isEmpty() || regionName == null) {
            StringId errMessage = null;
            if (keys.isEmpty() && regionName == null) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_IS_EMPTY_AND_THE_INPUT_REGION_NAME_IS_NULL_FOR_THE_REGISTER_INTEREST_REQUEST;
            } else if (keys.isEmpty()) {
                errMessage = LocalizedStrings.RegisterInterestList_THE_INPUT_LIST_OF_KEYS_FOR_THE_REGISTER_INTEREST_REQUEST_IS_EMPTY;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.RegisterInterest_THE_INPUT_REGION_NAME_FOR_THE_REGISTER_INTEREST_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", servConn.getName(), s);
            RegisterInterestList66.writeChunkedErrorResponse(msg, 21, s, servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                logger.info(LocalizedMessage.create(LocalizedStrings.RegisterInterestList_0_REGION_NAMED_1_WAS_NOT_FOUND_DURING_REGISTER_INTEREST_LIST_REQUEST, new Object[]{servConn.getName(), regionName}));
            }
            try {
                AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                if (authzRequest != null && !DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                    RegisterInterestOperationContext registerContext = authzRequest.registerInterestListAuthorize(regionName, keys, policy);
                    keys = (List)registerContext.getKey();
                }
                servConn.getAcceptor().getCacheClientNotifier().registerClientInterest(regionName, keys, servConn.getProxyID(), isDurable, sendUpdatesAsInvalidates, true, regionDataPolicyPartBytes[0], true);
            }
            catch (Exception ex) {
                RegisterInterestList66.checkForInterrupt(servConn, ex);
                RegisterInterestList66.writeChunkedException(msg, ex, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
            boolean isPrimary = servConn.getAcceptor().getCacheClientNotifier().getClientProxy(servConn.getProxyID()).isPrimary();
            if (!isPrimary) {
                chunkedResponseMsg.setMessageType(33);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                chunkedResponseMsg.setLastChunk(true);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sending register interest response chunk from secondary for region: {} for key: {} chunk=<{}>", servConn.getName(), regionName, key2, chunkedResponseMsg);
                }
                chunkedResponseMsg.sendChunk(servConn);
            } else {
                chunkedResponseMsg.setMessageType(32);
                chunkedResponseMsg.setTransactionId(msg.getTransactionId());
                chunkedResponseMsg.sendHeader();
                try {
                    RegisterInterestList66.fillAndSendRegisterInterestResponseChunks(region, keys, 0, serializeValues, policy, servConn);
                    servConn.setAsTrue(1);
                }
                catch (Exception e) {
                    RegisterInterestList66.checkForInterrupt(servConn, e);
                    RegisterInterestList66.writeChunkedException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent register interest response for the following {} keys in region {}: {}", servConn.getName(), numberOfKeys, regionName, keys);
                }
            }
        }
    }
}

