/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;
import java.nio.ByteBuffer;

public class RegisterDataSerializers
extends BaseCommand {
    private static final RegisterDataSerializers singleton = new RegisterDataSerializers();

    public static Command getCommand() {
        return singleton;
    }

    private RegisterDataSerializers() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received register dataserializer request ({} parts) from {}", servConn.getName(), msg.getNumberOfParts(), servConn.getSocketString());
        }
        int noOfParts = msg.getNumberOfParts();
        int noOfDataSerializers = (noOfParts - 1) / 2;
        ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(msg.getPart(noOfParts - 1).getSerializedForm());
        long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
        EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
        byte[][] serializedDataSerializers = new byte[noOfDataSerializers * 2][];
        boolean caughtCNFE = false;
        ClassNotFoundException cnfe = null;
        try {
            for (int i = 0; i < noOfParts - 1; i += 2) {
                Part dataSerializerClassNamePart = msg.getPart(i);
                serializedDataSerializers[i] = dataSerializerClassNamePart.getSerializedForm();
                String dataSerializerClassName = (String)CacheServerHelper.deserialize(serializedDataSerializers[i]);
                Part idPart = msg.getPart(i + 1);
                serializedDataSerializers[i + 1] = idPart.getSerializedForm();
                int id = idPart.getInt();
                Class<?> dataSerializerClass = null;
                try {
                    dataSerializerClass = InternalDataSerializer.getCachedClass(dataSerializerClassName);
                    InternalDataSerializer.register(dataSerializerClass, true, eventId, servConn.getProxyID());
                    continue;
                }
                catch (ClassNotFoundException e) {
                    caughtCNFE = true;
                    cnfe = e;
                }
            }
        }
        catch (Exception e) {
            RegisterDataSerializers.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
        }
        if (caughtCNFE) {
            RegisterDataSerializers.writeException(msg, cnfe, false, servConn);
            servConn.setAsTrue(1);
        }
        if (!servConn.getTransientFlag(1)) {
            this.writeReply(msg, servConn);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Registered dataserializer for MembershipId = {}", servConn.getMembershipID());
        }
    }
}

