/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.operations.QueryOperationContext;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.Set;

public class Query651
extends BaseCommand {
    private static final Query651 singleton = new Query651();

    public static Command getCommand() {
        return singleton;
    }

    private Query651() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String queryString = msg.getPart(0).getString();
        long compiledQueryId = 0L;
        Object[] queryParams = null;
        try {
            if (msg.getMessageType() == 80) {
                int params = msg.getPart(1).getInt();
                int paramStartIndex = 2;
                if (msg.getNumberOfParts() > 3 + params) {
                    int timeout = msg.getPart(3).getInt();
                    servConn.setRequestSpecificTimeout(timeout);
                    paramStartIndex = 4;
                }
                queryParams = new Object[params];
                for (int i = 0; i < queryParams.length; ++i) {
                    queryParams[i] = msg.getPart(i + paramStartIndex).getObject();
                }
            } else if (msg.getNumberOfParts() == 3) {
                int timeout = msg.getPart(2).getInt();
                servConn.setRequestSpecificTimeout(timeout);
            }
        }
        catch (ClassNotFoundException cne) {
            throw new QueryInvalidException(cne.getMessage() + queryString);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received query request from {} queryString: {}{}", servConn.getName(), servConn.getSocketString(), queryString, queryParams != null ? " with num query parameters :" + queryParams.length : "");
        }
        try {
            QueryService queryService = ((GemFireCacheImpl)servConn.getCachedRegionHelper().getCache()).getLocalQueryService();
            Query query = null;
            if (queryParams != null) {
                CacheClientNotifier ccn = servConn.getAcceptor().getCacheClientNotifier();
                query = ccn.getCompiledQuery(queryString);
                if (query == null) {
                    query = queryService.newQuery(queryString);
                    ccn.addCompiledQuery((DefaultQuery)query);
                }
                ccn.getStats().incCompiledQueryUsedCount(1L);
                ((DefaultQuery)query).setLastUsed(true);
            } else {
                query = queryService.newQuery(queryString);
            }
            Set regionNames = ((DefaultQuery)query).getRegionsInQuery(queryParams);
            QueryOperationContext queryContext = null;
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                queryContext = authzRequest.queryAuthorize(queryString, regionNames, queryParams);
                String newQueryString = queryContext.getQuery();
                if (queryString != null && !queryString.equals(newQueryString)) {
                    query = queryService.newQuery(newQueryString);
                    queryString = newQueryString;
                    regionNames = queryContext.getRegionNames();
                    if (regionNames == null) {
                        regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                    }
                }
            }
            Query651.processQueryUsingParams(msg, query, queryString, regionNames, start, null, queryContext, servConn, true, queryParams);
        }
        catch (QueryInvalidException e) {
            throw new QueryInvalidException(e.getMessage() + queryString);
        }
    }
}

