/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.operations.QueryOperationContext;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.Set;

public class Query
extends BaseCommand {
    private static final Query singleton = new Query();

    public static Command getCommand() {
        return singleton;
    }

    private Query() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String queryString = msg.getPart(0).getString();
        if (msg.getNumberOfParts() == 3) {
            int timeout = msg.getPart(2).getInt();
            servConn.setRequestSpecificTimeout(timeout);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received query request from {} queryString: {}", servConn.getName(), servConn.getSocketString(), queryString);
        }
        try {
            QueryService queryService = ((GemFireCacheImpl)servConn.getCachedRegionHelper().getCache()).getLocalQueryService();
            com.gemstone.gemfire.cache.query.Query query = queryService.newQuery(queryString);
            Set regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            QueryOperationContext queryContext = null;
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                queryContext = authzRequest.queryAuthorize(queryString, regionNames);
                String newQueryString = queryContext.getQuery();
                if (queryString != null && !queryString.equals(newQueryString)) {
                    query = queryService.newQuery(newQueryString);
                    queryString = newQueryString;
                    regionNames = queryContext.getRegionNames();
                    if (regionNames == null) {
                        regionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                    }
                }
            }
            Query.processQuery(msg, query, queryString, regionNames, start, null, queryContext, servConn, true);
        }
        catch (QueryInvalidException e) {
            throw new QueryInvalidException(e.getMessage() + queryString);
        }
        catch (QueryExecutionLowMemoryException e) {
            Query.writeQueryResponseException(msg, e, false, servConn);
        }
    }
}

