/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.operations.DestroyOperationContext;
import com.gemstone.gemfire.cache.operations.PutOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.BatchException;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ProcessBatch
extends BaseCommand {
    private static final ProcessBatch singleton = new ProcessBatch();
    private static final Set<String> notFoundRegions = new HashSet<String>();
    private static final Object notFoundRegionsSync = new Object();

    public static Command getCommand() {
        return singleton;
    }

    private ProcessBatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startp) throws IOException, ClassNotFoundException, InterruptedException {
        long start = startp;
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        int partNumber = 0;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        EventID eventId = null;
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadProcessBatchRequestTime(start - oldStart);
        boolean earlyAck = msg.getEarlyAck();
        stats.incBatchSize(msg.getPayloadLength());
        Part numberOfEventsPart = msg.getPart(0);
        int numberOfEvents = numberOfEventsPart.getInt();
        Part batchIdPart = msg.getPart(1);
        int batchId = batchIdPart.getInt();
        if (batchId == -1) {
            logger.info(LocalizedMessage.create(LocalizedStrings.ProcessBatch_RECEIVED_PROCESS_BATCH_REQUEST_FROM_A_NEW_PRIMARY_GATEWAY_CONTAINING_EVENTS_THAT_MAY_HAVE_ALREADY_BEEN_PROCESSED_THIS_PROCESS_BATCH_REQUEST_WILL_BE_PROCESSED));
        } else {
            if (batchId == servConn.getLatestBatchIdReplied()) {
                if (APPLY_RETRIES) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_RECEIVED_PROCESS_BATCH_REQUEST_0_THAT_HAS_ALREADY_BEEN_OR_IS_BEING_PROCESSED_GEMFIRE_GATEWAY_APPLYRETRIES_IS_SET_SO_THIS_BATCH_WILL_BE_PROCESSED_ANYWAY, batchId));
                } else {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_RECEIVED_PROCESS_BATCH_REQUEST_0_THAT_HAS_ALREADY_BEEN_OR_IS_BEING_PROCESSED__THIS_PROCESS_BATCH_REQUEST_IS_BEING_IGNORED, batchId));
                    return;
                }
            }
            if (batchId != servConn.getLatestBatchIdReplied() + 1) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_RECEIVED_PROCESS_BATCH_REQUEST_0_OUT_OF_ORDER_THE_ID_OF_THE_LAST_BATCH_PROCESSED_WAS_1_THIS_BATCH_REQUEST_WILL_BE_PROCESSED_BUT_SOME_MESSAGES_MAY_HAVE_BEEN_LOST, new Object[]{batchId, servConn.getLatestBatchIdReplied()}));
            }
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Received process batch request {} that will be processed.", batchId);
        }
        if (earlyAck) {
            if (batchId != -1) {
                servConn.incrementLatestBatchIdReplied(batchId);
            }
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            long oldStart2 = start;
            start = DistributionStats.getStatTime();
            stats.incWriteProcessBatchResponseTime(start - oldStart2);
        }
        partNumber = 2;
        int dsid = -1;
        if (isDebugEnabled) {
            logger.debug("{}: Received process batch request {} containing {} events ({} bytes) with {} acknowledgement on {}", servConn.getName(), batchId, numberOfEvents, msg.getPayloadLength(), earlyAck ? "early" : "normal", servConn.getSocketString());
            if (earlyAck) {
                logger.debug("{}: Sent process batch early response for batch {} containing {} events ({} bytes) with {} acknowledgement on {}", servConn.getName(), batchId, numberOfEvents, msg.getPayloadLength(), earlyAck ? "early" : "normal", servConn.getSocketString());
            }
        }
        boolean wroteResponse = earlyAck;
        for (int i = 0; i < numberOfEvents; ++i) {
            int extraParts = 0;
            Part actionTypePart = msg.getPart(partNumber);
            int actionType = actionTypePart.getInt();
            boolean callbackArgExists = false;
            long versionTimeStamp = Long.MIN_VALUE;
            EntryEventImpl clientEvent = null;
            try {
                try {
                    regionName = null;
                    key2 = null;
                    callbackArg = null;
                    switch (actionType) {
                        case 0: {
                            boolean result;
                            AuthorizeRequest authzRequest;
                            byte[] value2;
                            String reason;
                            Object[] messageArgs;
                            StringId message;
                            Part callbackArgExistsPart;
                            byte[] partBytes;
                            regionNamePart = msg.getPart(partNumber + 2);
                            regionName = regionNamePart.getString();
                            Part eventIdPart = msg.getPart(partNumber + 3);
                            eventIdPart.setVersion(servConn.getClientVersion());
                            try {
                                eventId = (EventID)eventIdPart.getObject();
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                            keyPart = msg.getPart(partNumber + 4);
                            try {
                                key2 = keyPart.getStringOrObject();
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                            valuePart = msg.getPart(partNumber + 5);
                            if (isDebugEnabled) {
                                logger.debug("{}: Processing batch create request {} on {} for region {} key {} value {} callbackArg {}", servConn.getName(), batchId, servConn.getSocketString(), regionName, key2, valuePart, callbackArg);
                            }
                            int index2 = partNumber + 6;
                            boolean bl = callbackArgExists = (partBytes = (byte[])(callbackArgExistsPart = msg.getPart(index2++)).getObject())[0] == 1;
                            if (callbackArgExists) {
                                ++extraParts;
                                callbackArgPart = msg.getPart(index2++);
                                try {
                                    callbackArg = callbackArgPart.getObject();
                                }
                                catch (Exception e) {
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_CREATE_REQUEST_1_FOR_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                    throw e;
                                }
                            }
                            if (key2 == null || regionName == null) {
                                message = null;
                                messageArgs = new Object[]{servConn.getName(), batchId};
                                if (key2 == null) {
                                    message = LocalizedStrings.ProcessBatch_0_THE_INPUT_REGION_NAME_FOR_THE_BATCH_CREATE_REQUEST_1_IS_NULL;
                                }
                                if (regionName == null) {
                                    message = LocalizedStrings.ProcessBatch_0_THE_INPUT_REGION_NAME_FOR_THE_BATCH_CREATE_REQUEST_1_IS_NULL;
                                }
                                String s = message.toLocalizedString(messageArgs);
                                logger.warn(s);
                                throw new Exception(s);
                            }
                            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
                            if (region == null) {
                                reason = LocalizedStrings.ProcessBatch_WAS_NOT_FOUND_DURING_BATCH_CREATE_REQUEST_0.toLocalizedString(regionName, batchId);
                                throw new RegionDestroyedException(reason, regionName);
                            }
                            clientEvent = new EntryEventImpl(eventId);
                            try {
                                value2 = valuePart.getSerializedForm();
                                boolean isObject = valuePart.isObject();
                                if (isObject && InternalDataSerializer.isSerializedNull(value2)) {
                                    value2 = null;
                                }
                                if (region.keyRequiresRegionContext()) {
                                    ((KeyWithRegionContext)key2).setRegionContext(region);
                                }
                                if ((authzRequest = servConn.getAuthzRequest()) != null) {
                                    PutOperationContext putContext = authzRequest.putAuthorize(regionName, key2, value2, isObject, callbackArg);
                                    value2 = putContext.getSerializedValue();
                                    isObject = putContext.isObject();
                                }
                                if (!(result = region.basicBridgeCreate(key2, value2, isObject, callbackArg, servConn.getProxyID(), false, clientEvent, false))) {
                                    result = region.basicBridgePut(key2, value2, null, isObject, callbackArg, servConn.getProxyID(), false, clientEvent, servConn.isSqlFabricSystem());
                                }
                                if (!result && !clientEvent.isConcurrencyConflict()) {
                                    throw new Exception(LocalizedStrings.ProcessBatch_0_FAILED_TO_CREATE_OR_UPDATE_ENTRY_FOR_REGION_1_KEY_2_VALUE_3_CALLBACKARG_4.toLocalizedString(servConn.getName(), regionName, key2, valuePart, callbackArg));
                                }
                                servConn.setModificationInfo(true, regionName, key2);
                                break;
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_CREATE_REQUEST_1_FOR_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                        }
                        case 1: {
                            boolean result;
                            AuthorizeRequest authzRequest;
                            byte[] value2;
                            String reason;
                            Object[] messageArgs;
                            StringId message;
                            regionNamePart = msg.getPart(partNumber + 2);
                            regionName = regionNamePart.getString();
                            Part eventIdPart = msg.getPart(partNumber + 3);
                            eventIdPart.setVersion(servConn.getClientVersion());
                            try {
                                eventId = (EventID)eventIdPart.getObject();
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                            keyPart = msg.getPart(partNumber + 4);
                            try {
                                key2 = keyPart.getStringOrObject();
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_UPDATE_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                            valuePart = msg.getPart(partNumber + 5);
                            int index2 = partNumber + 6;
                            Part callbackArgExistsPart = msg.getPart(index2++);
                            byte[] partBytes = (byte[])callbackArgExistsPart.getObject();
                            boolean bl = callbackArgExists = partBytes[0] == 1;
                            if (callbackArgExists) {
                                callbackArgPart = msg.getPart(index2++);
                                ++extraParts;
                                try {
                                    callbackArg = callbackArgPart.getObject();
                                }
                                catch (Exception e) {
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_UPDATE_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                    throw e;
                                }
                            }
                            if (isDebugEnabled) {
                                logger.debug("{}: Processing batch update request {} on {} for region {} key {} value {} callbackArg {}", batchId, servConn.getSocketString(), regionName, key2, valuePart, callbackArg, servConn.getName());
                            }
                            if (key2 == null || regionName == null) {
                                message = null;
                                messageArgs = new Object[]{servConn.getName(), batchId};
                                if (key2 == null) {
                                    message = LocalizedStrings.ProcessBatch_0_THE_INPUT_KEY_FOR_THE_BATCH_UPDATE_REQUEST_1_IS_NULL;
                                }
                                if (regionName == null) {
                                    message = LocalizedStrings.ProcessBatch_0_THE_INPUT_REGION_NAME_FOR_THE_BATCH_UPDATE_REQUEST_1_IS_NULL;
                                }
                                String s = message.toLocalizedString(messageArgs);
                                logger.warn(s);
                                throw new Exception(s);
                            }
                            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
                            if (region == null) {
                                reason = LocalizedStrings.ProcessBatch_WAS_NOT_FOUND_DURING_BATCH_CREATE_REQUEST_0.toLocalizedString(regionName, batchId);
                                throw new RegionDestroyedException(reason, regionName);
                            }
                            clientEvent = new EntryEventImpl(eventId);
                            try {
                                value2 = valuePart.getSerializedForm();
                                boolean isObject = valuePart.isObject();
                                if (region.keyRequiresRegionContext()) {
                                    ((KeyWithRegionContext)key2).setRegionContext(region);
                                }
                                if ((authzRequest = servConn.getAuthzRequest()) != null) {
                                    PutOperationContext putContext = authzRequest.putAuthorize(regionName, key2, value2, isObject, callbackArg, (byte)2);
                                    value2 = putContext.getSerializedValue();
                                    isObject = putContext.isObject();
                                }
                                if (!(result = region.basicBridgePut(key2, value2, null, isObject, callbackArg, servConn.getProxyID(), false, clientEvent, servConn.isSqlFabricSystem())) && !clientEvent.isConcurrencyConflict()) {
                                    Object[] msgArgs = new Object[]{servConn.getName(), regionName, key2, valuePart, callbackArg};
                                    StringId message2 = LocalizedStrings.ProcessBatch_0_FAILED_TO_UPDATE_ENTRY_FOR_REGION_1_KEY_2_VALUE_3_AND_CALLBACKARG_4;
                                    String s = message2.toLocalizedString(msgArgs);
                                    logger.info(s);
                                    throw new Exception(s);
                                }
                                servConn.setModificationInfo(true, regionName, key2);
                                break;
                            }
                            catch (CancelException e) {
                                if (servConn.getCachedRegionHelper().getCache().getCancelCriterion().cancelInProgress() != null) {
                                    if (isDebugEnabled) {
                                        logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getProxyID());
                                    }
                                } else {
                                    throw e;
                                }
                                servConn.setFlagProcessMessagesAsFalse();
                                if (actionType == 0 || actionType == 1) {
                                    partNumber += 7 + extraParts;
                                } else if (actionType == 2) {
                                    partNumber += 6 + extraParts;
                                }
                                return;
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_UPDATE_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                        }
                        case 2: {
                            String reason;
                            Object[] messageArgs;
                            StringId message;
                            regionNamePart = msg.getPart(partNumber + 2);
                            regionName = regionNamePart.getString();
                            Part eventIdPart = msg.getPart(partNumber + 3);
                            eventIdPart.setVersion(servConn.getClientVersion());
                            try {
                                eventId = (EventID)eventIdPart.getObject();
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_UPDATE_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                            keyPart = msg.getPart(partNumber + 4);
                            try {
                                key2 = keyPart.getStringOrObject();
                            }
                            catch (Exception e) {
                                logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_UPDATE_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                throw e;
                            }
                            int index2 = partNumber + 5;
                            Part callbackArgExistsPart = msg.getPart(index2++);
                            byte[] partBytes = (byte[])callbackArgExistsPart.getObject();
                            boolean bl = callbackArgExists = partBytes[0] == 1;
                            if (callbackArgExists) {
                                callbackArgPart = msg.getPart(index2++);
                                ++extraParts;
                                try {
                                    callbackArg = callbackArgPart.getObject();
                                }
                                catch (Exception e) {
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_CAUGHT_EXCEPTION_PROCESSING_BATCH_DESTROY_REQUEST_1_CONTAINING_2_EVENTS, new Object[]{servConn.getName(), batchId, numberOfEvents}), (Throwable)e);
                                    throw e;
                                }
                            }
                            if (isDebugEnabled) {
                                logger.debug("{}: Processing batch destroy request {} on {} for region {} key {}", servConn.getName(), batchId, servConn.getSocketString(), regionName, key2);
                            }
                            if (key2 == null || regionName == null) {
                                message = null;
                                if (key2 == null) {
                                    message = LocalizedStrings.ProcessBatch_0_THE_INPUT_KEY_FOR_THE_BATCH_DESTROY_REQUEST_1_IS_NULL;
                                }
                                if (regionName == null) {
                                    message = LocalizedStrings.ProcessBatch_0_THE_INPUT_REGION_NAME_FOR_THE_BATCH_DESTROY_REQUEST_1_IS_NULL;
                                }
                                messageArgs = new Object[]{servConn.getName(), batchId};
                                String s = message.toLocalizedString(messageArgs);
                                logger.warn(s);
                                throw new Exception(s);
                            }
                            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
                            if (region == null) {
                                reason = LocalizedStrings.ProcessBatch_WAS_NOT_FOUND_DURING_BATCH_CREATE_REQUEST_0.toLocalizedString(regionName, batchId);
                                throw new RegionDestroyedException(reason, regionName);
                            }
                            clientEvent = new EntryEventImpl(eventId);
                            if (region.keyRequiresRegionContext()) {
                                ((KeyWithRegionContext)key2).setRegionContext(region);
                            }
                            try {
                                AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                                if (authzRequest != null) {
                                    DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key2, callbackArg);
                                    callbackArg = destroyContext.getCallbackArg();
                                }
                                region.basicBridgeDestroy(key2, callbackArg, servConn.getProxyID(), false, clientEvent);
                                servConn.setModificationInfo(true, regionName, key2);
                            }
                            catch (EntryNotFoundException e) {
                                logger.info(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_DURING_BATCH_DESTROY_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{servConn.getName(), key2}));
                            }
                            break;
                        }
                        default: {
                            logger.fatal(LocalizedMessage.create(LocalizedStrings.Processbatch_0_UNKNOWN_ACTION_TYPE_1_FOR_BATCH_FROM_2, new Object[]{servConn.getName(), actionType, servConn.getSocketString()}));
                        }
                    }
                    if (actionType == 0 || actionType == 1) {
                        partNumber += 7 + extraParts;
                        continue;
                    }
                    if (actionType != 2) continue;
                    partNumber += 6 + extraParts;
                    continue;
                }
                catch (CancelException e) {
                    if (isDebugEnabled) {
                        logger.debug("{} ignoring message of type {} from client {} because shutdown occurred during message processing.", servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getProxyID());
                    }
                    servConn.setFlagProcessMessagesAsFalse();
                    if (actionType == 0 || actionType == 1) {
                        partNumber += 7 + extraParts;
                    } else if (actionType == 2) {
                        partNumber += 6 + extraParts;
                    }
                    return;
                }
                catch (Exception e) {
                    ProcessBatch.checkForInterrupt(servConn, e);
                    if (!wroteResponse) {
                        if (batchId != -1) {
                            servConn.incrementLatestBatchIdReplied(batchId);
                        }
                        ProcessBatch.writeBatchException(msg, e, i, servConn);
                        servConn.setAsTrue(1);
                        wroteResponse = true;
                        if (actionType == 0 || actionType == 1) {
                            partNumber += 7 + extraParts;
                            break;
                        }
                        if (actionType != 2) break;
                        partNumber += 6 + extraParts;
                        break;
                    }
                    if (actionType == 0 || actionType == 1) {
                        partNumber += 7 + extraParts;
                    } else if (actionType == 2) {
                        partNumber += 6 + extraParts;
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (actionType == 0 || actionType == 1) {
                    partNumber += 7 + extraParts;
                } else if (actionType == 2) {
                    partNumber += 6 + extraParts;
                }
                throw throwable;
            }
        }
        long oldStart3 = start;
        start = DistributionStats.getStatTime();
        stats.incProcessBatchTime(start - oldStart3);
        if (!wroteResponse) {
            if (batchId != -1) {
                servConn.incrementLatestBatchIdReplied(batchId);
            }
            this.writeReply(msg, servConn);
            servConn.setAsTrue(1);
            stats.incWriteProcessBatchResponseTime(DistributionStats.getStatTime() - start);
            if (isDebugEnabled) {
                logger.debug("{}: Sent process batch normal response for batch {} containing {} events ({} bytes) with {} acknowledgement on {}", servConn.getName(), batchId, numberOfEvents, msg.getPayloadLength(), earlyAck ? "early" : "normal", servConn.getSocketString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeBatchException(Message origMsg, Throwable e, int index2, ServerConnection servConn) throws IOException {
        BatchException be = new BatchException(e, index2);
        Message errorMsg = servConn.getErrorResponseMessage();
        errorMsg.setMessageType(2);
        errorMsg.setNumberOfParts(2);
        errorMsg.setTransactionId(origMsg.getTransactionId());
        errorMsg.addObjPart(be);
        errorMsg.addStringPart(be.toString());
        errorMsg.send(servConn);
        boolean logWarning = true;
        if (e instanceof RegionDestroyedException) {
            RegionDestroyedException rde = (RegionDestroyedException)e;
            Object object = notFoundRegionsSync;
            synchronized (object) {
                if (notFoundRegions.contains(rde.getRegionFullPath())) {
                    logWarning = false;
                } else {
                    notFoundRegions.add(rde.getRegionFullPath());
                }
            }
        }
        if (logWarning) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ProcessBatch_0_WROTE_BATCH_EXCEPTION, servConn.getName()), (Throwable)be);
        }
    }
}

