/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.BucketServerLocation66;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class GetClientPRMetadataCommand66
extends BaseCommand {
    private static final GetClientPRMetadataCommand66 singleton = new GetClientPRMetadataCommand66();

    public static Command getCommand() {
        return singleton;
    }

    private GetClientPRMetadataCommand66() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, ClassNotFoundException, InterruptedException {
        String regionFullPath = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        regionFullPath = msg.getPart(0).getString();
        String errMessage = "";
        if (regionFullPath == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.GetClientPRMetadata_THE_INPUT_REGION_PATH_IS_NULL));
            errMessage = LocalizedStrings.GetClientPRMetadata_THE_INPUT_REGION_PATH_IS_NULL.toLocalizedString();
            GetClientPRMetadataCommand66.writeErrorResponse(msg, 75, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionFullPath);
            if (region == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.GetClientPRMetadata_REGION_NOT_FOUND_FOR_SPECIFIED_REGION_PATH, regionFullPath));
                errMessage = LocalizedStrings.GetClientPRMetadata_REGION_NOT_FOUND.toLocalizedString() + regionFullPath;
                GetClientPRMetadataCommand66.writeErrorResponse(msg, 75, errMessage.toString(), servConn);
                servConn.setAsTrue(1);
            } else {
                try {
                    Message responseMsg = servConn.getResponseMessage();
                    responseMsg.setTransactionId(msg.getTransactionId());
                    responseMsg.setMessageType(72);
                    PartitionedRegion prRgion = (PartitionedRegion)region;
                    Map<Integer, List<BucketServerLocation66>> bucketToServerLocations = prRgion.getRegionAdvisor().getAllClientBucketProfiles();
                    responseMsg.setNumberOfParts(bucketToServerLocations.size());
                    for (List<BucketServerLocation66> serverLocations : bucketToServerLocations.values()) {
                        responseMsg.addObjPart(serverLocations);
                    }
                    responseMsg.send();
                    msg.flush();
                }
                catch (Exception e) {
                    GetClientPRMetadataCommand66.writeException(msg, e, false, servConn);
                }
                finally {
                    servConn.setAsTrue(1);
                }
            }
        }
    }
}

