/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import java.io.IOException;

public class GetCQStats
extends BaseCommand {
    private static final GetCQStats singleton = new GetCQStats();

    public static Command getCommand() {
        return singleton;
    }

    private GetCQStats() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received close all client CQs request from {}", servConn.getName(), servConn.getSocketString());
        }
        String cqName = msg.getPart(0).getString();
        if (isDebugEnabled) {
            logger.debug("{}: Received close CQ request from {} cqName: {}", servConn.getName(), servConn.getSocketString(), cqName);
        }
        if (cqName == null) {
            String err = "The cqName for the cq stats request is null";
            GetCQStats.sendCqResponse(47, err, msg.getTransactionId(), null, servConn);
            return;
        }
        try {
            CqService.getCqService(crHelper.getCache());
        }
        catch (Exception e) {
            String err = "Exception while Getting the CQ Statistics. ";
            GetCQStats.sendCqResponse(50, err, msg.getTransactionId(), e, servConn);
            return;
        }
        GetCQStats.sendCqResponse(6, "cq stats sent successfully.", msg.getTransactionId(), null, servConn);
        servConn.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessGetCqStatsTime(start - oldStart);
    }
}

