/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.operations.GetOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.internal.security.AuthorizeRequestPP;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;

public class Get70
extends BaseCommand {
    private static final Get70 singleton = new Get70();

    public static Command getCommand() {
        return singleton;
    }

    protected Get70() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startparam) throws IOException {
        long start = startparam;
        Part regionNamePart = null;
        Part keyPart = null;
        Part valuePart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        StringId errMessage = null;
        if (crHelper.emulateSlowServer() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                Thread.sleep(crHelper.emulateSlowServer());
            }
            catch (InterruptedException ugh) {
                interrupted = true;
                servConn.getCachedRegionHelper().getCache().getCancelCriterion().checkCancelInProgress(ugh);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadGetRequestTime(start - oldStart);
        int parts = msg.getNumberOfParts();
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        if (parts > 2) {
            valuePart = msg.getPart(2);
            try {
                callbackArg = valuePart.getObject();
            }
            catch (Exception e) {
                Get70.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Get70.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received 7.0 get request ({} bytes) from {} for region {} key {} txId {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key2, msg.getTransactionId());
        }
        if (key2 == null || regionName == null) {
            if (key2 == null && regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_AND_KEY_FOR_THE_GET_REQUEST_ARE_NULL;
            } else if (key2 == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_KEY_FOR_THE_GET_REQUEST_IS_NULL;
            } else if (regionName == null) {
                errMessage = LocalizedStrings.Request_THE_INPUT_REGION_NAME_FOR_THE_GET_REQUEST_IS_NULL;
            }
            String s = errMessage.toLocalizedString();
            logger.warn("{}: {}", servConn.getName(), s);
            Get70.writeErrorResponse(msg, 3, s, servConn);
            servConn.setAsTrue(1);
        } else {
            Region region = crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Request__0_WAS_NOT_FOUND_DURING_GET_REQUEST.toLocalizedString(regionName);
                Get70.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                Entry entry;
                GetOperationContext getContext = null;
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        getContext = authzRequest.getAuthorize(regionName, key2, callbackArg);
                        callbackArg = getContext.getCallbackArg();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Get70.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                try {
                    entry = this.getValueAndIsObject(region, key2, callbackArg, servConn);
                }
                catch (Exception e) {
                    Get70.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                Object data = entry.value;
                boolean isObject = entry.isObject;
                VersionTag versionTag = entry.versionTag;
                boolean keyNotPresent = entry.keyNotPresent;
                try {
                    AuthorizeRequestPP postAuthzRequest = servConn.getPostAuthzRequest();
                    if (postAuthzRequest != null) {
                        byte[] serializedValue = (getContext = postAuthzRequest.getAuthorize(regionName, key2, data, isObject, getContext)).getSerializedValue();
                        data = serializedValue == null ? getContext.getObject() : (Object)serializedValue;
                        isObject = getContext.isObject();
                    }
                }
                catch (NotAuthorizedException ex) {
                    Get70.writeException(msg, ex, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessGetTime(start - oldStart2);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    if (pr2.isNetworkHop() != 0) {
                        this.writeResponseWithRefreshMetadata(data, callbackArg, msg, isObject, servConn, pr2, pr2.isNetworkHop(), versionTag, keyNotPresent);
                        pr2.setIsNetworkHop((byte)0);
                        pr2.setMetadataVersion((byte)0);
                    } else {
                        this.writeResponse(data, callbackArg, msg, isObject, versionTag, keyNotPresent, servConn);
                    }
                } else {
                    this.writeResponse(data, callbackArg, msg, isObject, versionTag, keyNotPresent, servConn);
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Wrote get response back to {} for region {} {}", servConn.getName(), servConn.getSocketString(), regionName, entry);
                }
                stats.incWriteGetResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }

    public Entry getValueAndIsObject(Region region, Object key2, Object callbackArg, ServerConnection servConn) {
        String regionName = region.getFullPath();
        if (servConn != null) {
            servConn.setModificationInfo(true, regionName, key2);
        }
        VersionTag versionTag = null;
        boolean isObject = true;
        Object data = null;
        EntryEventImpl versionHolder = EntryEventImpl.createVersionTagHolder();
        ClientProxyMembershipID id = servConn == null ? null : servConn.getProxyID();
        data = ((LocalRegion)region).get(key2, callbackArg, true, true, true, id, versionHolder, true);
        versionTag = versionHolder.getVersionTag();
        boolean wasInvalid = false;
        if (data instanceof CachedDeserializable) {
            data = ((CachedDeserializable)data).getValue();
        } else if (data == Token.REMOVED_PHASE1 || data == Token.REMOVED_PHASE2 || data == Token.DESTROYED) {
            data = null;
        } else if (data == Token.INVALID || data == Token.LOCAL_INVALID) {
            data = null;
            wasInvalid = true;
        } else if (data instanceof byte[]) {
            isObject = false;
        }
        Entry result = new Entry();
        result.value = data;
        result.isObject = isObject;
        result.keyNotPresent = !wasInvalid && (data == null || data == Token.TOMBSTONE);
        result.versionTag = versionTag;
        return result;
    }

    @Override
    protected void writeReply(Message origMsg, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeReplyWithRefreshMetadata(Message origMsg, ServerConnection servConn, PartitionedRegion pr2, byte nwHop) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, VersionTag versionTag, boolean keyNotPresent, ServerConnection servConn) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        int numParts = 2;
        int flags = 0;
        if (callbackArg != null) {
            ++numParts;
            flags |= 1;
        }
        if (versionTag != null) {
            ++numParts;
            flags |= 2;
        }
        if (keyNotPresent) {
            flags |= 4;
        } else if (data == null && isObject) {
            flags |= 8;
        }
        responseMsg.setNumberOfParts(numParts);
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        responseMsg.addIntPart(flags);
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        if (versionTag != null) {
            responseMsg.addObjPart(versionTag);
        }
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.flush();
    }

    protected static void writeResponse(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void writeResponseWithRefreshMetadata(Object data, Object callbackArg, Message origMsg, boolean isObject, ServerConnection servConn, PartitionedRegion pr2, byte nwHop, VersionTag versionTag, boolean keyNotPresent) throws IOException {
        Message responseMsg = servConn.getResponseMessage();
        responseMsg.setMessageType(1);
        responseMsg.setTransactionId(origMsg.getTransactionId());
        int numParts = 3;
        int flags = 0;
        if (callbackArg != null) {
            ++numParts;
            flags |= 1;
        }
        if (versionTag != null) {
            ++numParts;
            flags |= 2;
        }
        if (keyNotPresent) {
            flags |= 4;
        } else if (data == null && isObject) {
            flags |= 8;
        }
        responseMsg.setNumberOfParts(numParts);
        if (data instanceof byte[]) {
            responseMsg.addRawPart((byte[])data, isObject);
        } else {
            Assert.assertTrue(isObject, "isObject should be true when value is not a byte[]");
            responseMsg.addObjPart(data, false);
        }
        responseMsg.addIntPart(flags);
        if (callbackArg != null) {
            responseMsg.addObjPart(callbackArg);
        }
        if (versionTag != null) {
            responseMsg.addObjPart(versionTag);
        }
        responseMsg.addBytesPart(new byte[]{pr2.getMetadataVersion(), nwHop});
        servConn.getCache().getCancelCriterion().checkCancelInProgress(null);
        responseMsg.send(servConn);
        origMsg.flush();
    }

    public static class Entry {
        public Object value;
        public boolean isObject;
        public boolean keyNotPresent;
        public VersionTag versionTag;

        public String toString() {
            return "value=" + this.value + " isObject=" + this.isObject + " notPresent=" + this.keyNotPresent + " version=" + this.versionTag;
        }
    }
}

