/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.operations.ExecuteFunctionOperationContext;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.PartitionedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.HashSet;

public class ExecuteRegionFunction
extends BaseCommand {
    private static final ExecuteRegionFunction singleton = new ExecuteRegionFunction();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteRegionFunction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper;
        byte hasResult;
        HashSet<Object> filter;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        String regionName;
        block34: {
            regionName = null;
            function = null;
            args = null;
            memberMappedArg = null;
            filter = null;
            hasResult = 0;
            int filterSize = 0;
            int partNumber = 0;
            crHelper = servConn.getCachedRegionHelper();
            try {
                Object obj;
                hasResult = msg.getPart(0).getSerializedForm()[0];
                if (hasResult == 1) {
                    servConn.setAsTrue(2);
                    servConn.setAsTrue(3);
                }
                regionName = msg.getPart(1).getString();
                function = msg.getPart(2).getStringOrObject();
                args = msg.getPart(3).getObject();
                Part part = msg.getPart(4);
                if (part != null && (obj = part.getObject()) instanceof MemberMappedArgument) {
                    memberMappedArg = (MemberMappedArgument)obj;
                }
                if ((filterSize = msg.getPart(5).getInt()) != 0) {
                    filter = new HashSet<Object>();
                    partNumber = 6;
                    for (int i = 0; i < filterSize; ++i) {
                        filter.add(msg.getPart(partNumber + i).getStringOrObject());
                    }
                }
            }
            catch (ClassNotFoundException exception) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
                if (hasResult != 1) break block34;
                ExecuteRegionFunction.writeChunkedException(msg, exception, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if (function == null || regionName == null) {
            String message = null;
            if (function == null) {
                message = LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("function");
            }
            if (regionName == null) {
                message = LocalizedStrings.ExecuteRegionFunction_THE_INPUT_0_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString("region");
            }
            logger.warn("{}: {}", servConn.getName(), message);
            this.sendError(hasResult, msg, message, servConn);
            return;
        }
        Region region = crHelper.getRegion(regionName);
        if (region == null) {
            String message = LocalizedStrings.ExecuteRegionFunction_THE_REGION_NAMED_0_WAS_NOT_FOUND_DURING_EXECUTE_FUNCTION_REQUEST.toLocalizedString(regionName);
            logger.warn("{}: {}", servConn.getName(), message);
            this.sendError(hasResult, msg, message, servConn);
            return;
        }
        HandShake handShake = (HandShake)servConn.getHandshake();
        int earlierClientReadTimeout = handShake.getClientReadTimeout();
        handShake.setClientReadTimeout(0);
        ServerToClientFunctionResultSender resultSender = null;
        Function functionObject = null;
        try {
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = LocalizedStrings.ExecuteRegionFunction_THE_FUNCTION_0_HAS_NOT_BEEN_REGISTERED.toLocalizedString(function);
                    logger.warn("{}: {}", servConn.getName(), message);
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            String functionName = functionObject.getId();
            String regionPath = region.getFullPath();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionName, regionPath, filter, args, functionObject.optimizeForWrite());
            }
            AbstractExecution execution = (AbstractExecution)FunctionService.onRegion(region);
            ChunkedMessage m = servConn.getFunctionResponseMessage();
            m.setTransactionId(msg.getTransactionId());
            resultSender = new ServerToClientFunctionResultSender(m, 60, servConn, functionObject, executeContext);
            execution = execution instanceof PartitionedRegionFunctionExecutor ? new PartitionedRegionFunctionExecutor((PartitionedRegion)region, filter, args, memberMappedArg, resultSender, null) : new DistributedRegionFunctionExecutor((DistributedRegion)region, filter, args, memberMappedArg, resultSender);
            if (logger.isDebugEnabled()) {
                logger.debug("Executing Function: {} on Server: {} with Execution: {}", functionObject.getId(), servConn, execution);
            }
            if (hasResult == 1) {
                if (function instanceof String) {
                    execution.execute((String)function).getResult();
                } else {
                    execution.execute(functionObject).getResult();
                }
            } else if (function instanceof String) {
                execution.execute((String)function);
            } else {
                execution.execute(functionObject);
            }
        }
        catch (IOException ioe) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioe);
            String message = LocalizedStrings.ExecuteRegionFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
            this.sendException(hasResult, msg, message, servConn, ioe);
        }
        catch (InternalFunctionInvocationTargetException internalfunctionException) {
            if (logger.isDebugEnabled()) {
                logger.debug(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{function}), (Throwable)internalfunctionException);
            }
            String message = internalfunctionException.getMessage();
            this.sendException(hasResult, msg, message, servConn, internalfunctionException);
        }
        catch (FunctionException fe) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)fe);
            String message = fe.getMessage();
            this.sendException(hasResult, msg, message, servConn, fe);
        }
        catch (Exception e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteRegionFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
            String message = e.getMessage();
            this.sendException(hasResult, msg, message, servConn, e);
        }
        finally {
            handShake.setClientReadTimeout(earlierClientReadTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(byte hasResult, Message msg, String message, ServerConnection servConn, Throwable e) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction.writeFunctionResponseException(msg, 2, message, servConn, e);
                servConn.setAsTrue(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendError(byte hasResult, Message msg, String message, ServerConnection servConn) throws IOException {
        Message message2 = msg;
        synchronized (message2) {
            if (hasResult == 1) {
                ExecuteRegionFunction.writeFunctionResponseError(msg, 61, message, servConn);
                servConn.setAsTrue(1);
            }
        }
    }
}

