/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.operations.ExecuteFunctionOperationContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.FunctionContextImpl;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender65;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecuteFunction66
extends BaseCommand {
    private static final ExecuteFunction66 singleton = new ExecuteFunction66();
    protected static volatile boolean ASYNC_TX_WARNING_ISSUED = false;
    static final ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){
        AtomicInteger threadNum = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r, "Function Execution Thread-" + this.threadNum.incrementAndGet());
            result.setDaemon(true);
            return result;
        }
    });

    public static Command getCommand() {
        return singleton;
    }

    protected ExecuteFunction66() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        String message;
        Object function = null;
        Object args = null;
        MemberMappedArgument memberMappedArg = null;
        String[] groups = null;
        byte hasResult = 0;
        byte functionState = 0;
        boolean isReexecute = false;
        boolean allMembers = false;
        boolean ignoreFailedMembers = false;
        int functionTimeout = 0;
        try {
            byte[] bytes = msg.getPart(0).getSerializedForm();
            functionState = bytes[0];
            if (bytes.length >= 5 && servConn.getClientVersion().ordinal() >= Version.GFE_81.ordinal()) {
                functionTimeout = Part.decodeInt(bytes, 1);
            }
            if (functionState == 11) {
                functionState = 3;
                isReexecute = true;
            } else if (functionState == 15) {
                functionState = 7;
                isReexecute = true;
            }
            hasResult = functionState != 1 ? (byte)((byte)((functionState & 2) - 1)) : functionState;
            if (hasResult == 1) {
                servConn.setAsTrue(2);
                servConn.setAsTrue(3);
            }
            function = msg.getPart(1).getStringOrObject();
            args = msg.getPart(2).getObject();
            Part part = msg.getPart(3);
            if (part != null) {
                memberMappedArg = (MemberMappedArgument)part.getObject();
            }
            groups = this.getGroups(msg);
            allMembers = this.getAllMembers(msg);
            ignoreFailedMembers = this.getIgnoreFailedMembers(msg);
        }
        catch (ClassNotFoundException exception) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
            if (hasResult == 1) {
                ExecuteFunction66.writeChunkedException(msg, exception, false, servConn);
            } else {
                ExecuteFunction66.writeException(msg, exception, false, servConn);
            }
            servConn.setAsTrue(1);
            return;
        }
        if (function == null) {
            String message2 = LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString();
            logger.warn(LocalizedMessage.create(LocalizedStrings.TWO_ARG_COLON, new Object[]{servConn.getName(), message2}));
            this.sendError(hasResult, msg, message2, servConn);
            return;
        }
        try {
            Function functionObject = null;
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    message = LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(function);
                    logger.warn("{}: {}", servConn.getName(), message);
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
                byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                if (logger.isDebugEnabled()) {
                    logger.debug("Function State on server side: {} on client: {}", functionStateOnServerSide, functionState);
                }
                if (functionStateOnServerSide != functionState) {
                    String message3 = LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(function);
                    logger.warn("{}: {}", servConn.getName(), message3);
                    this.sendError(hasResult, msg, message3, servConn);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStats.getFunctionStats(functionObject.getId(), null);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage m = servConn.getFunctionResponseMessage();
            m.setTransactionId(msg.getTransactionId());
            ServerToClientFunctionResultSender65 resultSender = new ServerToClientFunctionResultSender65(m, 63, servConn, functionObject, executeContext);
            InternalDistributedMember localVM = InternalDistributedSystem.getAnyInstance().getDistributedMember();
            FunctionContextImpl context = null;
            context = memberMappedArg != null ? new FunctionContextImpl(functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender, isReexecute) : new FunctionContextImpl(functionObject.getId(), args, resultSender, isReexecute);
            HandShake handShake = (HandShake)servConn.getHandshake();
            int earlierClientReadTimeout = handShake.getClientReadTimeout();
            handShake.setClientReadTimeout(functionTimeout);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: {} with context: {}", servConn, context);
                }
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (functionObject.optimizeForWrite() && cache != null && cache.getResourceManager().isHeapCritical() && !InternalResourceManager.isLowMemoryExceptionDisabled()) {
                    Set<DistributedMember> sm = Collections.singleton(cache.getMyId());
                    LowMemoryException e = new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(functionObject.getId(), sm), sm);
                    this.sendException(hasResult, msg, e.getMessage(), servConn, e);
                    return;
                }
                DM dm = null;
                if (cache != null) {
                    dm = cache.getDistributionManager();
                }
                if (groups != null && groups.length > 0) {
                    this.executeFunctionOnGroups(function, args, groups, allMembers, functionObject, resultSender, ignoreFailedMembers);
                } else {
                    this.executeFunctionaLocally(functionObject, context, resultSender, dm, stats);
                }
                if (!functionObject.hasResult()) {
                    this.writeReply(msg, servConn);
                }
            }
            catch (FunctionException functionException) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw functionException;
            }
            catch (Exception exception) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw new FunctionException(exception);
            }
            finally {
                handShake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException ioException) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioException);
            message = LocalizedStrings.ExecuteFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
            this.sendException(hasResult, msg, message, servConn, ioException);
        }
        catch (InternalFunctionInvocationTargetException internalfunctionException) {
            if (logger.isDebugEnabled()) {
                logger.debug(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{function}), (Throwable)internalfunctionException);
            }
            message = internalfunctionException.getMessage();
            this.sendException(hasResult, msg, message, servConn, internalfunctionException);
        }
        catch (Exception e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
            message = e.getMessage();
            this.sendException(hasResult, msg, message, servConn, e);
        }
    }

    protected boolean getIgnoreFailedMembers(Message msg) {
        return false;
    }

    protected boolean getAllMembers(Message msg) {
        return false;
    }

    protected void executeFunctionOnGroups(Object function, Object args, String[] groups, boolean allMembers, Function functionObject, ServerToClientFunctionResultSender resultSender, boolean ignoreFailedMembers) {
        throw new InternalGemFireError();
    }

    protected String[] getGroups(Message msg) throws IOException, ClassNotFoundException {
        return null;
    }

    private void executeFunctionaLocally(final Function fn, final FunctionContext cx, ServerToClientFunctionResultSender65 sender, DM dm, final FunctionStats stats) throws IOException {
        long startExecution = stats.startTime();
        stats.startFunctionExecution(fn.hasResult());
        if (fn.hasResult()) {
            fn.execute(cx);
            if (!sender.isLastResultReceived() && fn.hasResult()) {
                throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(fn.getId()));
            }
        } else {
            final TXStateProxy txState = TXManagerImpl.getCurrentTXState();
            Runnable functionExecution = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GemFireCacheImpl cache = null;
                    try {
                        if (txState != null) {
                            cache = GemFireCacheImpl.getExisting("executing function");
                            cache.getTxManager().masqueradeAs(txState);
                            if (cache.getLoggerI18n().warningEnabled() && !ASYNC_TX_WARNING_ISSUED) {
                                ASYNC_TX_WARNING_ISSUED = true;
                                cache.getLoggerI18n().warning(LocalizedStrings.ExecuteFunction66_TRANSACTIONAL_FUNCTION_WITHOUT_RESULT);
                            }
                        }
                        fn.execute(cx);
                    }
                    catch (InternalFunctionInvocationTargetException internalfunctionException) {
                        stats.endFunctionExecutionWithException(fn.hasResult());
                        if (logger.isDebugEnabled()) {
                            logger.debug(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{fn}), (Throwable)internalfunctionException);
                        }
                    }
                    catch (FunctionException functionException) {
                        stats.endFunctionExecutionWithException(fn.hasResult());
                        logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, fn), (Throwable)functionException);
                    }
                    catch (Exception exception) {
                        stats.endFunctionExecutionWithException(fn.hasResult());
                        logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, fn), (Throwable)exception);
                    }
                    finally {
                        if (txState != null && cache != null) {
                            cache.getTxManager().unmasquerade(txState);
                        }
                    }
                }
            };
            if (dm == null) {
                execService.execute(functionExecution);
            } else {
                DistributionManager newDM = (DistributionManager)dm;
                newDM.getFunctionExcecutor().execute(functionExecution);
            }
        }
        stats.endFunctionExecution(startExecution, fn.hasResult());
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection servConn, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction66.writeFunctionResponseException(msg, 2, message, servConn, e);
        } else {
            ExecuteFunction66.writeException(msg, e, false, servConn);
        }
        servConn.setAsTrue(1);
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection servConn) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction66.writeFunctionResponseError(msg, 64, message, servConn);
        } else {
            ExecuteFunction66.writeErrorResponse(msg, 64, message, servConn);
        }
        servConn.setAsTrue(1);
    }
}

