/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.operations.ExecuteFunctionOperationContext;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.cache.execute.AbstractExecution;
import com.gemstone.gemfire.internal.cache.execute.FunctionContextImpl;
import com.gemstone.gemfire.internal.cache.execute.FunctionStats;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.execute.MemberMappedArgument;
import com.gemstone.gemfire.internal.cache.execute.ServerToClientFunctionResultSender65;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.HandShake;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class ExecuteFunction65
extends BaseCommand {
    private static final ExecuteFunction65 singleton = new ExecuteFunction65();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteFunction65() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        boolean isReexecute;
        byte functionState;
        byte hasResult;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        block29: {
            function = null;
            args = null;
            memberMappedArg = null;
            hasResult = 0;
            functionState = 0;
            isReexecute = false;
            try {
                functionState = msg.getPart(0).getSerializedForm()[0];
                if (functionState == 11) {
                    functionState = 3;
                    isReexecute = true;
                } else if (functionState == 15) {
                    functionState = 7;
                    isReexecute = true;
                }
                hasResult = functionState != 1 ? (byte)((byte)((functionState & 2) - 1)) : functionState;
                if (hasResult == 1) {
                    servConn.setAsTrue(2);
                    servConn.setAsTrue(3);
                }
                function = msg.getPart(1).getStringOrObject();
                args = msg.getPart(2).getObject();
                Part part = msg.getPart(3);
                if (part != null) {
                    memberMappedArg = (MemberMappedArgument)part.getObject();
                }
            }
            catch (ClassNotFoundException exception) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)exception);
                if (hasResult != true) break block29;
                ExecuteFunction65.writeChunkedException(msg, exception, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        if (function == null) {
            String message = LocalizedStrings.ExecuteFunction_THE_INPUT_FUNCTION_FOR_THE_EXECUTE_FUNCTION_REQUEST_IS_NULL.toLocalizedString();
            logger.warn("{}: {}", servConn.getName(), message);
            this.sendError(hasResult, msg, message, servConn);
            return;
        }
        try {
            Function functionObject = null;
            if (function instanceof String) {
                functionObject = FunctionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = LocalizedStrings.ExecuteFunction_FUNCTION_NAMED_0_IS_NOT_REGISTERED.toLocalizedString(function);
                    logger.warn("{}: {}", servConn.getName(), message);
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
                byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                if (logger.isDebugEnabled()) {
                    logger.debug("Function State on server side: {} on client: {}", functionStateOnServerSide, functionState);
                }
                if (functionStateOnServerSide != functionState) {
                    String message = LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH_CLIENT_SERVER.toLocalizedString(function);
                    logger.warn("{}: {}", servConn.getName(), message);
                    this.sendError(hasResult, msg, message, servConn);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStats.getFunctionStats(functionObject.getId(), null);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage m = servConn.getFunctionResponseMessage();
            m.setTransactionId(msg.getTransactionId());
            ServerToClientFunctionResultSender65 resultSender = new ServerToClientFunctionResultSender65(m, 63, servConn, functionObject, executeContext);
            InternalDistributedMember localVM = InternalDistributedSystem.getAnyInstance().getDistributedMember();
            FunctionContextImpl context = null;
            context = memberMappedArg != null ? new FunctionContextImpl(functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender, isReexecute) : new FunctionContextImpl(functionObject.getId(), args, resultSender, isReexecute);
            HandShake handShake = (HandShake)servConn.getHandshake();
            int earlierClientReadTimeout = handShake.getClientReadTimeout();
            handShake.setClientReadTimeout(0);
            try {
                long startExecution = stats.startTime();
                stats.startFunctionExecution(functionObject.hasResult());
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: {} with context: {}", servConn, context);
                }
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                if (functionObject.optimizeForWrite() && cache != null && cache.getResourceManager().isHeapCritical() && !InternalResourceManager.isLowMemoryExceptionDisabled()) {
                    Set<DistributedMember> sm = Collections.singleton(cache.getMyId());
                    LowMemoryException e = new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_0_FUNCEXEC_MEMBERS_1.toLocalizedString(functionObject.getId(), sm), sm);
                    this.sendException(hasResult, msg, e.getMessage(), servConn, e);
                    return;
                }
                functionObject.execute(context);
                if (!resultSender.isLastResultReceived() && functionObject.hasResult()) {
                    throw new FunctionException(LocalizedStrings.ExecuteFunction_THE_FUNCTION_0_DID_NOT_SENT_LAST_RESULT.toString(functionObject.getId()));
                }
                stats.endFunctionExecution(startExecution, functionObject.hasResult());
            }
            catch (FunctionException functionException) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw functionException;
            }
            catch (Exception exception) {
                stats.endFunctionExecutionWithException(functionObject.hasResult());
                throw new FunctionException(exception);
            }
            finally {
                handShake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException ioException) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)ioException);
            String message = LocalizedStrings.ExecuteFunction_SERVER_COULD_NOT_SEND_THE_REPLY.toLocalizedString();
            this.sendException(hasResult, msg, message, servConn, ioException);
        }
        catch (InternalFunctionInvocationTargetException internalfunctionException) {
            if (logger.isDebugEnabled()) {
                logger.debug(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, new Object[]{function}), (Throwable)internalfunctionException);
            }
            String message = internalfunctionException.getMessage();
            this.sendException(hasResult, msg, message, servConn, internalfunctionException);
        }
        catch (Exception e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.ExecuteFunction_EXCEPTION_ON_SERVER_WHILE_EXECUTIONG_FUNCTION_0, function), (Throwable)e);
            String message = e.getMessage();
            this.sendException(hasResult, msg, message, servConn, e);
        }
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection servConn, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction65.writeFunctionResponseException(msg, 2, message, servConn, e);
            servConn.setAsTrue(1);
        }
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection servConn) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction65.writeFunctionResponseError(msg, 64, message, servConn);
            servConn.setAsTrue(1);
        }
    }
}

