/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.operations.ExecuteCQOperationContext;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.Set;

public class ExecuteCQ
extends BaseCommand {
    private static final ExecuteCQ singleton = new ExecuteCQ();

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteCQ() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException, InterruptedException {
        boolean isDurable;
        AcceptorImpl acceptor = servConn.getAcceptor();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        String cqName = msg.getPart(0).getString();
        String cqQueryString = msg.getPart(1).getString();
        int cqState = msg.getPart(2).getInt();
        Part isDurablePart = msg.getPart(3);
        byte[] isDurableByte = isDurablePart.getSerializedForm();
        boolean bl = isDurable = isDurableByte != null && isDurableByte[0] != 0;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {} CqName: {} queryString: {}", servConn.getName(), MessageType.getString(msg.getMessageType()), servConn.getSocketString(), cqName, cqQueryString);
        }
        DefaultQueryService qService = null;
        CqService cqServiceForExec = null;
        Query query = null;
        Set cqRegionNames = null;
        ExecuteCQOperationContext executeCQContext = null;
        CqQueryImpl cqQuery = null;
        try {
            String newCqQueryString;
            qService = (DefaultQueryService)((GemFireCacheImpl)crHelper.getCache()).getLocalQueryService();
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null && !cqQueryString.equals(newCqQueryString = (executeCQContext = authzRequest.executeCQAuthorize(cqName, cqQueryString, cqRegionNames = ((DefaultQuery)(query = qService.newQuery(cqQueryString))).getRegionsInQuery(null))).getQuery())) {
                query = qService.newQuery(newCqQueryString);
                cqQueryString = newCqQueryString;
                cqRegionNames = executeCQContext.getRegionNames();
                if (cqRegionNames == null) {
                    cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
                }
            }
            cqServiceForExec = qService.getCqService();
            cqQuery = (CqQueryImpl)cqServiceForExec.executeCq(cqName, cqQueryString, cqState, id, acceptor.getCacheClientNotifier(), isDurable, false, 0, null);
        }
        catch (CqException cqe) {
            ExecuteCQ.sendCqResponse(50, "", msg.getTransactionId(), cqe, servConn);
            return;
        }
        catch (Exception e) {
            ExecuteCQ.writeChunkedException(msg, e, false, servConn);
            return;
        }
        long oldstart = start;
        boolean sendResults = false;
        boolean successQuery = false;
        if (msg.getMessageType() == 43) {
            sendResults = true;
        }
        try {
            if (query == null) {
                query = qService.newQuery(cqQueryString);
                cqRegionNames = ((DefaultQuery)query).getRegionsInQuery(null);
            }
            ((DefaultQuery)query).setIsCqQuery(true);
            successQuery = ExecuteCQ.processQuery(msg, query, cqQueryString, cqRegionNames, start, cqQuery, executeCQContext, servConn, sendResults);
            cqQuery.getVsdStats().setCqInitialResultsTime(DistributionStats.getStatTime() - oldstart);
            stats.incProcessExecuteCqWithIRTime(DistributionStats.getStatTime() - oldstart);
        }
        finally {
            if (!successQuery) {
                try {
                    cqServiceForExec.closeCq(cqName, id);
                }
                catch (Exception ex) {}
            }
        }
        if (!sendResults && successQuery) {
            ExecuteCQ.sendCqResponse(6, LocalizedStrings.ExecuteCQ_CQ_CREATED_SUCCESSFULLY.toLocalizedString(), msg.getTransactionId(), null, servConn);
            long start2 = DistributionStats.getStatTime();
            stats.incProcessCreateCqTime(start2 - oldstart);
        }
        servConn.setAsTrue(1);
    }
}

