/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.operations.DestroyOperationContext;
import com.gemstone.gemfire.cache.operations.RegionDestroyOperationContext;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Destroy
extends BaseCommand {
    private static final Destroy singleton = new Destroy();

    public static Command getCommand() {
        return singleton;
    }

    private Destroy() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long startparam) throws IOException, InterruptedException {
        long start = startparam;
        Part regionNamePart = null;
        Part keyPart = null;
        Part callbackArgPart = null;
        String regionName = null;
        Object callbackArg = null;
        Object key2 = null;
        Part eventPart = null;
        StringBuffer errMessage = new StringBuffer();
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incReadDestroyRequestTime(start - oldStart);
        regionNamePart = msg.getPart(0);
        keyPart = msg.getPart(1);
        eventPart = msg.getPart(2);
        if (msg.getNumberOfParts() > 3) {
            callbackArgPart = msg.getPart(3);
            try {
                callbackArg = callbackArgPart.getObject();
            }
            catch (Exception e) {
                Destroy.writeException(msg, e, false, servConn);
                servConn.setAsTrue(1);
                return;
            }
        }
        regionName = regionNamePart.getString();
        try {
            key2 = keyPart.getStringOrObject();
        }
        catch (Exception e) {
            Destroy.writeException(msg, e, false, servConn);
            servConn.setAsTrue(1);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received destroy request ({} bytes) from {} for region {} key {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), regionName, key2);
        }
        if (key2 == null || regionName == null) {
            if (key2 == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_KEY_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL, servConn.getName()));
                errMessage.append(LocalizedStrings.Destroy__THE_INPUT_REGION_NAME_FOR_THE_DESTROY_REQUEST_IS_NULL.toLocalizedString());
            }
            Destroy.writeErrorResponse(msg, 10, errMessage.toString(), servConn);
            servConn.setAsTrue(1);
        } else {
            LocalRegion region = (LocalRegion)crHelper.getRegion(regionName);
            if (region == null) {
                String reason = LocalizedStrings.Destroy__0_WAS_NOT_FOUND_DURING_DESTROY_REQUEST.toLocalizedString(regionName);
                Destroy.writeRegionDestroyedEx(msg, regionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                ByteBuffer eventIdPartsBuffer = ByteBuffer.wrap(eventPart.getSerializedForm());
                long threadId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                long sequenceId = EventID.readEventIdPartsFromOptmizedByteArray(eventIdPartsBuffer);
                EventID eventId = new EventID(servConn.getEventMemberIDByteArray(), threadId, sequenceId);
                try {
                    AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                    if (authzRequest != null) {
                        if (DynamicRegionFactory.regionIsDynamicRegionList(regionName)) {
                            RegionDestroyOperationContext destroyContext = authzRequest.destroyRegionAuthorize((String)key2, callbackArg);
                            callbackArg = destroyContext.getCallbackArg();
                        } else {
                            DestroyOperationContext destroyContext = authzRequest.destroyAuthorize(regionName, key2, callbackArg);
                            callbackArg = destroyContext.getCallbackArg();
                        }
                    }
                    region.basicBridgeDestroy(key2, callbackArg, servConn.getProxyID(), true, new EntryEventImpl(eventId));
                    servConn.setModificationInfo(true, regionName, key2);
                }
                catch (EntryNotFoundException e) {
                    logger.info(LocalizedMessage.create(LocalizedStrings.Destroy_0_DURING_ENTRY_DESTROY_NO_ENTRY_WAS_FOUND_FOR_KEY_1, new Object[]{servConn.getName(), key2}));
                }
                catch (RegionDestroyedException rde) {
                    Destroy.writeException(msg, rde, false, servConn);
                    servConn.setAsTrue(1);
                    return;
                }
                catch (Exception e) {
                    Destroy.checkForInterrupt(servConn, e);
                    Destroy.writeException(msg, e, false, servConn);
                    servConn.setAsTrue(1);
                    if (e instanceof GemFireSecurityException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: Unexpected Security exception", servConn.getName(), e);
                        }
                    } else {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.Destroy_0_UNEXPECTED_EXCEPTION, servConn.getName()), (Throwable)e);
                    }
                    return;
                }
                long oldStart2 = start;
                start = DistributionStats.getStatTime();
                stats.incProcessDestroyTime(start - oldStart2);
                if (region instanceof PartitionedRegion) {
                    PartitionedRegion pr2 = (PartitionedRegion)region;
                    if (pr2.isNetworkHop() != 0) {
                        this.writeReplyWithRefreshMetadata(msg, servConn, pr2, pr2.isNetworkHop());
                        pr2.setIsNetworkHop((byte)0);
                        pr2.setMetadataVersion((byte)0);
                    } else {
                        this.writeReply(msg, servConn);
                    }
                } else {
                    this.writeReply(msg, servConn);
                }
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent destroy response for region {} key {}", servConn.getName(), regionName, key2);
                }
                stats.incWriteDestroyResponseTime(DistributionStats.getStatTime() - start);
            }
        }
    }
}

