/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import com.gemstone.gemfire.security.NotAuthorizedException;
import java.io.IOException;

public class CreateRegion
extends BaseCommand {
    private static final CreateRegion singleton = new CreateRegion();

    public static Command getCommand() {
        return singleton;
    }

    private CreateRegion() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        Part regionNamePart = null;
        String regionName = null;
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        servConn.setAsTrue(2);
        Part parentRegionNamePart = msg.getPart(0);
        String parentRegionName = parentRegionNamePart.getString();
        regionNamePart = msg.getPart(1);
        regionName = regionNamePart.getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received create region request ({} bytes) from {} for parent region {} region {}", servConn.getName(), msg.getPayloadLength(), servConn.getSocketString(), parentRegionName, regionName);
        }
        if (parentRegionName == null || regionName == null) {
            String errMessage = "";
            if (parentRegionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CreateRegion_0_THE_INPUT_PARENT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.CreateRegion_THE_INPUT_PARENT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL.toLocalizedString();
            }
            if (regionName == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CreateRegion_0_THE_INPUT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL, servConn.getName()));
                errMessage = LocalizedStrings.CreateRegion_THE_INPUT_REGION_NAME_FOR_THE_CREATE_REGION_REQUEST_IS_NULL.toLocalizedString();
            }
            CreateRegion.writeErrorResponse(msg, 30, errMessage, servConn);
            servConn.setAsTrue(1);
        } else {
            Region parentRegion = crHelper.getRegion(parentRegionName);
            if (parentRegion == null) {
                String reason = LocalizedStrings.CreateRegion__0_WAS_NOT_FOUND_DURING_SUBREGION_CREATION_REQUEST.toLocalizedString(parentRegionName);
                CreateRegion.writeRegionDestroyedEx(msg, parentRegionName, reason, servConn);
                servConn.setAsTrue(1);
            } else {
                Region<Object, Object> region;
                AuthorizeRequest authzRequest = servConn.getAuthzRequest();
                if (authzRequest != null) {
                    try {
                        authzRequest.createRegionAuthorize(parentRegionName + '/' + regionName);
                    }
                    catch (NotAuthorizedException ex) {
                        CreateRegion.writeException(msg, ex, false, servConn);
                        servConn.setAsTrue(1);
                        return;
                    }
                }
                if ((region = parentRegion.getSubregion(regionName)) == null) {
                    AttributesFactory factory = new AttributesFactory(parentRegion.getAttributes());
                    region = parentRegion.createSubregion(regionName, factory.create());
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}: Created region {}", servConn.getName(), region);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("{}: Retrieved region {}", servConn.getName(), region);
                }
                this.writeReply(msg, servConn);
                servConn.setAsTrue(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: Sent create region response for parent region {} region {}", servConn.getName(), parentRegionName, regionName);
                }
            }
        }
    }
}

