/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets.command;

import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.Command;
import com.gemstone.gemfire.internal.cache.tier.sockets.BaseCommand;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.security.AuthorizeRequest;
import java.io.IOException;
import java.util.HashSet;

public class CloseCQ
extends BaseCommand {
    private static final CloseCQ singleton = new CloseCQ();

    public static Command getCommand() {
        return singleton;
    }

    private CloseCQ() {
    }

    @Override
    public void cmdExecute(Message msg, ServerConnection servConn, long start) throws IOException {
        CachedRegionHelper crHelper = servConn.getCachedRegionHelper();
        ClientProxyMembershipID id = servConn.getProxyID();
        CacheServerStats stats = servConn.getCacheServerStats();
        servConn.setAsTrue(2);
        servConn.setAsTrue(3);
        start = DistributionStats.getStatTime();
        String cqName = msg.getPart(0).getString();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received close CQ request from {} cqName: {}", servConn.getName(), servConn.getSocketString(), cqName);
        }
        if (cqName == null) {
            String err = LocalizedStrings.CloseCQ_THE_CQNAME_FOR_THE_CQ_CLOSE_REQUEST_IS_NULL.toLocalizedString();
            CloseCQ.sendCqResponse(47, err, msg.getTransactionId(), null, servConn);
            return;
        }
        try {
            CqService cqService = CqService.getCqService(crHelper.getCache());
            String serverCqName = cqName;
            if (id != null) {
                serverCqName = cqService.constructServerCqName(cqName, id);
            }
            CqQuery cqQuery = cqService.getCq(serverCqName);
            AuthorizeRequest authzRequest = servConn.getAuthzRequest();
            if (authzRequest != null) {
                String queryStr = null;
                HashSet<String> cqRegionNames = null;
                if (cqQuery != null) {
                    queryStr = cqQuery.getQueryString();
                    cqRegionNames = new HashSet<String>();
                    cqRegionNames.add(((CqQueryImpl)cqQuery).getRegionName());
                    authzRequest.closeCQAuthorize(cqName, queryStr, cqRegionNames);
                }
            }
            cqService.closeCq(cqName, id);
            if (cqQuery != null) {
                servConn.removeCq(cqName, cqQuery.isDurable());
            }
        }
        catch (CqException cqe) {
            CloseCQ.sendCqResponse(50, "", msg.getTransactionId(), cqe, servConn);
            return;
        }
        catch (Exception e) {
            String err = LocalizedStrings.CloseCQ_EXCEPTION_WHILE_CLOSING_CQ_CQNAME_0.toLocalizedString(cqName);
            CloseCQ.sendCqResponse(50, err, msg.getTransactionId(), e, servConn);
            return;
        }
        CloseCQ.sendCqResponse(6, LocalizedStrings.CloseCQ_CQ_CLOSED_SUCCESSFULLY.toLocalizedString(), msg.getTransactionId(), null, servConn);
        servConn.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessCloseCqTime(start - oldStart);
    }
}

