/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList651;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class SerializedObjectPartList
extends ObjectPartList651 {
    public SerializedObjectPartList() {
    }

    public SerializedObjectPartList(int maximumchunksize, boolean hasKeys) {
        super(maximumchunksize, hasKeys);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.hasKeys);
        if (this.objectTypeArray != null) {
            int numObjects = this.objects.size();
            out.writeInt(numObjects);
            for (int index2 = 0; index2 < numObjects; ++index2) {
                Object value2 = this.objects.get(index2);
                byte objectType = this.objectTypeArray[index2];
                if (this.hasKeys) {
                    DataSerializer.writeObject(this.keys.get(index2), out);
                }
                if (objectType == 3) {
                    out.writeByte(3);
                } else if (objectType == 2) {
                    out.writeByte(2);
                } else if (objectType == 0) {
                    out.writeByte(0);
                } else {
                    out.writeByte(1);
                }
                if (objectType == 2) {
                    DataSerializer.writeByteArray(CacheServerHelper.serialize(value2), out);
                    DataSerializer.writeString(value2.toString(), out);
                    continue;
                }
                if (value2 instanceof byte[]) {
                    DataSerializer.writeByteArray((byte[])value2, out);
                    continue;
                }
                DataSerializer.writeObjectAsByteArray(value2, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean keysPresent = in.readBoolean();
        if (keysPresent) {
            this.keys = new ArrayList();
        }
        this.hasKeys = keysPresent;
        int numObjects = in.readInt();
        this.objectTypeArray = new byte[numObjects];
        if (numObjects > 0) {
            for (int index2 = 0; index2 < numObjects; ++index2) {
                Object value2;
                byte objectType;
                if (keysPresent) {
                    Object key2 = DataSerializer.readObject(in);
                    this.keys.add(key2);
                }
                this.objectTypeArray[index2] = objectType = in.readByte();
                if (objectType == 2) {
                    byte[] exBytes = DataSerializer.readByteArray(in);
                    value2 = CacheServerHelper.deserialize(exBytes);
                    DataSerializer.readString(in);
                } else {
                    value2 = DataSerializer.readByteArray(in);
                }
                this.objects.add(value2);
            }
        }
    }

    public boolean isBytes(int index2) {
        return this.objectTypeArray[index2] == 0;
    }

    public boolean isException(int index2) {
        return this.objectTypeArray[index2] == 2;
    }

    @Override
    public int getDSFID() {
        return 2125;
    }
}

