/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class ObjectPartList651
extends ObjectPartList {
    public ObjectPartList651() {
    }

    public ObjectPartList651(int maximumchunksize, boolean b) {
        super(maximumchunksize, b);
    }

    @Override
    public void addObjectPartForAbsentKey(Object key2, Object value2) {
        this.addPart(key2, value2, (byte)3, null);
    }

    @Override
    public void addAll(ObjectPartList other) {
        if (this.hasKeys) {
            this.keys.addAll(other.keys);
        } else if (other.hasKeys) {
            this.hasKeys = true;
            this.keys = other.keys;
        }
        for (int i = 0; i < other.objects.size(); ++i) {
            this.objects.add(other.objects.get(i));
        }
        if (this.objectTypeArray != null) {
            byte[] temp = new byte[this.objectTypeArray.length];
            System.arraycopy(this.objectTypeArray, 0, temp, 0, this.objectTypeArray.length);
            this.objectTypeArray = new byte[this.objects.size()];
            System.arraycopy(temp, 0, this.objectTypeArray, 0, temp.length);
            System.arraycopy(other.objectTypeArray, 0, this.objectTypeArray, temp.length, other.objectTypeArray.length);
        } else {
            this.objectTypeArray = new byte[this.objects.size()];
            System.arraycopy(other.objectTypeArray, 0, this.objectTypeArray, 0, other.objectTypeArray.length);
        }
    }

    public boolean isKeyNotOnServer(int index2) {
        return this.objectTypeArray[index2] == 3;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.hasKeys);
        if (this.objectTypeArray != null) {
            int numObjects = this.objects.size();
            out.writeInt(numObjects);
            for (int index2 = 0; index2 < numObjects; ++index2) {
                Object value2 = this.objects.get(index2);
                byte objectType = this.objectTypeArray[index2];
                if (this.hasKeys) {
                    DataSerializer.writeObject(this.keys.get(index2), out);
                }
                if (objectType == 3) {
                    out.writeByte(3);
                } else if (objectType == 2) {
                    out.writeByte(2);
                } else {
                    out.writeByte(1);
                }
                if (objectType == 1 && value2 instanceof byte[]) {
                    out.write((byte[])value2);
                    continue;
                }
                if (objectType == 2) {
                    DataSerializer.writeByteArray(CacheServerHelper.serialize(value2), out);
                    DataSerializer.writeString(value2.toString(), out);
                    continue;
                }
                DataSerializer.writeObject(value2, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        boolean keysPresent = in.readBoolean();
        if (keysPresent) {
            this.keys = new ArrayList();
        }
        this.hasKeys = keysPresent;
        int numObjects = in.readInt();
        this.objectTypeArray = new byte[numObjects];
        if (numObjects > 0) {
            for (int index2 = 0; index2 < numObjects; ++index2) {
                Object value2;
                byte objectType;
                if (keysPresent) {
                    Object key2 = DataSerializer.readObject(in);
                    this.keys.add(key2);
                }
                this.objectTypeArray[index2] = objectType = in.readByte();
                if (objectType == 2) {
                    byte[] exBytes = DataSerializer.readByteArray(in);
                    value2 = CacheServerHelper.deserialize(exBytes);
                    DataSerializer.readString(in);
                } else {
                    value2 = DataSerializer.readObject(in);
                }
                this.objects.add(value2);
            }
        }
    }

    @Override
    public int getDSFID() {
        return 2121;
    }
}

