/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerHelper;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class ObjectPartList
implements DataSerializableFixedID {
    private static final Logger logger = LogService.getLogger();
    protected static final byte BYTES = 0;
    protected static final byte OBJECT = 1;
    protected static final byte EXCEPTION = 2;
    protected static final byte KEY_NOT_AT_SERVER = 3;
    protected byte[] objectTypeArray;
    protected boolean hasKeys;
    protected List keys;
    protected List objects;

    public void addPart(Object key2, Object value2, byte objectType, VersionTag versionTag) {
        int maxSize;
        int size2 = this.objects.size();
        if (size2 >= (maxSize = this.objectTypeArray.length)) {
            throw new IndexOutOfBoundsException("Cannot add object part beyond " + maxSize + " elements");
        }
        if (this.hasKeys) {
            if (key2 == null) {
                throw new IllegalArgumentException("Cannot add null key");
            }
            this.keys.add(key2);
        }
        this.objectTypeArray[size2] = objectType;
        this.objects.add(value2);
    }

    public ObjectPartList() {
        this.objectTypeArray = null;
        this.hasKeys = false;
        this.keys = null;
        this.objects = new ArrayList();
    }

    public ObjectPartList(int maxSize, boolean hasKeys) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Invalid size " + maxSize + " to ObjectPartList constructor");
        }
        this.objectTypeArray = new byte[maxSize];
        this.hasKeys = hasKeys;
        this.keys = hasKeys ? new ArrayList() : null;
        this.objects = new ArrayList();
    }

    public void addObjectPart(Object key2, Object value2, boolean isObject, VersionTag versionTag) {
        this.addPart(key2, value2, isObject ? (byte)1 : 0, versionTag);
    }

    public void addExceptionPart(Object key2, Exception ex) {
        this.addPart(key2, ex, (byte)2, null);
    }

    public void addObjectPartForAbsentKey(Object key2, Object value2) {
        throw new IllegalAccessError("inappropriate use of ObjectPartList");
    }

    public void addAll(ObjectPartList other) {
        if (logger.isTraceEnabled(LogMarker.OBJECT_PART_LIST)) {
            logger.trace(LogMarker.OBJECT_PART_LIST, "OPL.addAll: other={}\nthis={}", other, this);
        }
        if (this.hasKeys) {
            if (other.keys != null) {
                if (this.keys == null) {
                    this.keys = new ArrayList(other.keys);
                } else {
                    this.keys.addAll(other.keys);
                }
            }
        } else if (other.hasKeys) {
            this.hasKeys = true;
            this.keys = new ArrayList(other.keys);
        }
        this.objects.addAll(other.objects);
    }

    public List getKeys() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.keys);
    }

    public List getKeysForTest() {
        return this.keys;
    }

    public List getObjects() {
        if (this.objects == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.objects);
    }

    public List getObjectsForTest() {
        return this.objects;
    }

    public int size() {
        if (this.hasKeys) {
            return this.keys.size();
        }
        return this.objects.size();
    }

    public void reinit(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("Invalid size " + maxSize + " to ObjectPartList.reinit");
        }
        this.objectTypeArray = new byte[maxSize];
        this.objects.clear();
        this.keys.clear();
    }

    public void clear() {
        this.objects.clear();
        if (this.keys != null) {
            this.keys.clear();
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.hasKeys);
        if (this.objectTypeArray != null) {
            int numObjects = this.objects.size();
            out.writeInt(numObjects);
            for (int index2 = 0; index2 < numObjects; ++index2) {
                Object value2 = this.objects.get(index2);
                byte objectType = this.objectTypeArray[index2];
                if (this.hasKeys) {
                    DataSerializer.writeObject(this.keys.get(index2), out);
                }
                out.writeBoolean(objectType == 2);
                if (objectType == 1 && value2 instanceof byte[]) {
                    out.write((byte[])value2);
                    continue;
                }
                if (objectType == 2) {
                    DataSerializer.writeByteArray(CacheServerHelper.serialize(value2), out);
                    DataSerializer.writeString(value2.toString(), out);
                    continue;
                }
                DataSerializer.writeObject(value2, out);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int numObjects;
        this.hasKeys = in.readBoolean();
        if (this.hasKeys) {
            this.keys = new ArrayList();
        }
        if ((numObjects = in.readInt()) > 0) {
            for (int index2 = 0; index2 < numObjects; ++index2) {
                Object value2;
                boolean isException;
                if (this.hasKeys) {
                    Object key2 = DataSerializer.readObject(in);
                    this.keys.add(key2);
                }
                if (isException = in.readBoolean()) {
                    byte[] exBytes = DataSerializer.readByteArray(in);
                    value2 = CacheServerHelper.deserialize(exBytes);
                    DataSerializer.readString(in);
                } else {
                    value2 = DataSerializer.readObject(in);
                }
                this.objects.add(value2);
            }
        }
    }

    @Override
    public int getDSFID() {
        return 25;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

