/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;

public final class ClientProxyMembershipID
implements DataSerializableFixedID,
Serializable,
Externalizable {
    private static final Logger logger = LogService.getLogger();
    private static ThreadLocal<String> POOL_NAME = new ThreadLocal();
    private static final int BYTES_32KB = 32768;
    public static volatile DistributedSystem system = null;
    public static DistributedMember systemMemberId;
    private static final int durable_synch_counter = 1;
    private static int synch_counter;
    protected byte[] identity;
    private transient DistributedMember memberId;
    private transient String memberIdString;
    protected int uniqueId;
    private transient Version clientVersion;
    private transient String _toString;

    public static void setPoolName(String poolName) {
        POOL_NAME.set(poolName);
    }

    public static String getPoolName() {
        return POOL_NAME.get();
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        if (this.isDurable()) {
            result = 37 * result + this.getDurableId().hashCode();
        } else if (this.identity != null && this.identity.length > 0) {
            for (int i = 0; i < this.identity.length; ++i) {
                result = 37 * result + this.identity[i];
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ClientProxyMembershipID)) {
            return false;
        }
        ClientProxyMembershipID that = (ClientProxyMembershipID)obj;
        if (this.uniqueId != that.uniqueId) {
            return false;
        }
        boolean isDurable = this.isDurable();
        if (isDurable && !that.isDurable()) {
            return false;
        }
        if (isDurable) {
            return this.getDurableId().equals(that.getDurableId());
        }
        return Arrays.equals(this.identity, that.identity);
    }

    private boolean isCanonicalEquals(ClientProxyMembershipID that) {
        if (this == that) {
            return true;
        }
        if (this.uniqueId != that.uniqueId) {
            return false;
        }
        return Arrays.equals(this.identity, that.identity);
    }

    boolean isSameDSMember(ClientProxyMembershipID that) {
        if (that != null) {
            return this.isDurable() ? this.getDurableId().equals(that.getDurableId()) : Arrays.equals(this.identity, that.identity);
        }
        return false;
    }

    public static synchronized ClientProxyMembershipID getNewProxyMembership(DistributedSystem sys) {
        byte[] ba = ClientProxyMembershipID.initializeAndGetDSIdentity(sys);
        return new ClientProxyMembershipID(++synch_counter, ba);
    }

    public static ClientProxyMembershipID getClientId(DistributedMember member) {
        return new ClientProxyMembershipID(member);
    }

    public static byte[] initializeAndGetDSIdentity(DistributedSystem sys) {
        byte[] client_side_identity = null;
        if (sys == null) {
            throw new IllegalStateException(LocalizedStrings.ClientProxyMembershipID_ATTEMPTING_TO_HANDSHAKE_WITH_CACHESERVER_BEFORE_CREATING_DISTRIBUTEDSYSTEM_AND_CACHE.toLocalizedString());
        }
        systemMemberId = sys.getDistributedMember();
        try {
            HeapDataOutputStream hdos = new HeapDataOutputStream(256, Version.CURRENT);
            DataSerializer.writeObject(systemMemberId, hdos);
            client_side_identity = hdos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalGemFireException(LocalizedStrings.ClientProxyMembershipID_UNABLE_TO_SERIALIZE_IDENTITY.toLocalizedString(), ioe);
        }
        system = sys;
        return client_side_identity;
    }

    private ClientProxyMembershipID(int id, byte[] clientSideIdentity) {
        Boolean specialCase = Boolean.getBoolean("gemfire.SPECIAL_DURABLE");
        String durableID = system.getProperties().getProperty("durable-client-id");
        this.uniqueId = specialCase != false && durableID != null && !durableID.equals("") ? 1 : id;
        this.identity = clientSideIdentity;
        this.memberId = systemMemberId;
    }

    public ClientProxyMembershipID() {
    }

    public ClientProxyMembershipID(DistributedMember member) {
        this.uniqueId = 1;
        this.memberId = member;
        this.updateID(member);
    }

    public String toString() {
        if (this.identity != null && ((InternalDistributedMember)this.getDistributedMember()).getPort() == 0) {
            return this.toStringNoCache();
        }
        if (this._toString == null) {
            this._toString = this.toStringNoCache();
        }
        return this._toString;
    }

    public String toStringNoCache() {
        DurableClientAttributes dca;
        StringBuffer sb = new StringBuffer("identity(").append(this.getDSMembership()).append(",connection=").append(this.uniqueId);
        if (this.identity != null && (dca = this.getDurableAttributes()).getId().length() > 0) {
            sb.append(",durableAttributes=").append(this.getDurableAttributes()).append(')').toString();
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Assert.assertTrue(this.identity.length <= 32768);
        out.writeShort(this.identity.length);
        out.write(this.identity);
        out.writeInt(this.uniqueId);
    }

    public int getSerializedSize() {
        return 4 + this.identity.length + 4;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short identityLength = in.readShort();
        if (identityLength > 32768) {
            throw new IOException(LocalizedStrings.ClientProxyMembershipID_HANDSHAKE_IDENTITY_LENGTH_IS_TOO_BIG.toLocalizedString());
        }
        this.identity = new byte[identityLength];
        this.read(in, this.identity);
        this.uniqueId = in.readInt();
        if (this.uniqueId == -1) {
            throw new IOException(LocalizedStrings.ClientProxyMembershipID_UNEXPECTED_EOF_REACHED_UNIQUE_ID_COULD_NOT_BE_READ.toLocalizedString());
        }
    }

    private void read(ObjectInput dis, byte[] toFill) throws IOException {
        int dataRead;
        int toFillLength = toFill.length;
        for (int idBytes = 0; idBytes < toFillLength; idBytes += dataRead) {
            dataRead = dis.read(toFill, idBytes, toFillLength - idBytes);
            if (dataRead != -1) continue;
            throw new IOException(LocalizedStrings.ClientProxyMembershipID_UNEXPECTED_EOF_REACHED_DISTRIBUTED_MEMBERSHIPID_COULD_NOT_BE_READ.toLocalizedString());
        }
    }

    @Override
    public int getDSFID() {
        return 38;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.identity, out);
        out.writeInt(this.uniqueId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.clientVersion = InternalDataSerializer.getVersionForDataStream(in);
        this.identity = DataSerializer.readByteArray(in);
        this.uniqueId = in.readInt();
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public String getDSMembership() {
        if (this.identity == null) {
            return "null";
        }
        if (((InternalDistributedMember)this.getDistributedMember()).getPort() == 0) {
            return this.getDistributedMember().toString();
        }
        if (this.memberIdString == null) {
            this.memberIdString = this.getDistributedMember().toString();
        }
        return this.memberIdString;
    }

    private ClientProxyMembershipID canonicalReference() {
        CacheClientProxy cp;
        CacheClientNotifier ccn = CacheClientNotifier.getInstance();
        if (ccn != null && (cp = ccn.getClientProxy(this, true)) != null && this.isCanonicalEquals(cp.getProxyID())) {
            return cp.getProxyID();
        }
        return this;
    }

    public DistributedMember getDistributedMember() {
        block3: {
            if (this.memberId == null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.identity);
                VersionedDataInputStream dis = new VersionedDataInputStream(bais, this.clientVersion);
                try {
                    this.memberId = (DistributedMember)DataSerializer.readObject(dis);
                }
                catch (Exception e) {
                    InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                    if (ds == null) break block3;
                    logger.error(LocalizedMessage.create(LocalizedStrings.ClientProxyMembershipID_UNABLE_TO_DESERIALIZE_MEMBERSHIP_ID), (Throwable)e);
                }
            }
        }
        return this.memberId;
    }

    byte[] getMembershipByteArray() {
        return this.identity;
    }

    public boolean isDurable() {
        String durableClientId = this.getDistributedMember().getDurableClientAttributes().getId();
        return durableClientId != null && durableClientId.length() != 0;
    }

    protected DurableClientAttributes getDurableAttributes() {
        return this.getDistributedMember().getDurableClientAttributes();
    }

    public String getDurableId() {
        DurableClientAttributes dca = this.getDurableAttributes();
        return dca == null ? "" : dca.getId();
    }

    protected int getDurableTimeout() {
        DurableClientAttributes dca = this.getDurableAttributes();
        return dca == null ? 0 : dca.getTimeout();
    }

    public void updateDurableTimeout(int newValue) {
        DurableClientAttributes dca = this.getDurableAttributes();
        if (dca != null) {
            dca.updateTimeout(newValue);
        }
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Only applicable in client DS and in that case too multiple instances do not modify it at the same time.")
    public void updateID(DistributedMember idm) {
        HeapDataOutputStream hdos = new HeapDataOutputStream(256, Version.CURRENT);
        try {
            DataSerializer.writeObject(idm, hdos);
        }
        catch (IOException e) {
            throw new InternalGemFireException("Unable to serialize member: " + this.memberId, e);
        }
        this.identity = hdos.toByteArray();
        if (this.memberId != null && this.memberId == systemMemberId) {
            systemMemberId = idm;
        }
        this.memberId = idm;
        this._toString = null;
    }

    protected String getHARegionName() {
        return this.getBaseRegionName() + "_queue";
    }

    protected String getInterestRegionName() {
        return this.getBaseRegionName() + "_interest";
    }

    private String getBaseRegionName() {
        String id;
        String string = id = this.isDurable() ? this.getDurableId() : this.getDSMembership();
        if (id.indexOf(47) >= 0) {
            id = id.replace('/', ':');
        }
        StringBuffer buffer = new StringBuffer().append("_gfe_").append(this.isDurable() ? "" : "non_").append("durable_client_").append("with_id_" + id).append("_").append(this.uniqueId);
        return buffer.toString();
    }

    public static synchronized void resetUniqueIdCounter() {
        synch_counter = 0;
    }

    public Identity getIdentity() {
        return new Identity();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    public static ClientProxyMembershipID readCanonicalized(DataInput in) throws IOException, ClassNotFoundException {
        ClientProxyMembershipID result = (ClientProxyMembershipID)DataSerializer.readObject(in);
        if (result == null || result.identity == null) {
            return result;
        }
        return result.canonicalReference();
    }

    static {
        synch_counter = 0;
    }

    public class Identity {
        public int getUniqueId() {
            return ClientProxyMembershipID.this.uniqueId;
        }

        public byte[] getMemberIdBytes() {
            return ClientProxyMembershipID.this.identity;
        }

        public int hashCode() {
            int result = 17;
            int mult = 37;
            byte[] idBytes = this.getMemberIdBytes();
            if (idBytes != null && idBytes.length > 0) {
                for (int i = 0; i < idBytes.length; ++i) {
                    result = 37 * result + idBytes[i];
                }
            }
            result = 37 * result + ClientProxyMembershipID.this.uniqueId;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Identity)) {
                return false;
            }
            Identity that = (Identity)obj;
            return this.getUniqueId() == that.getUniqueId() && Arrays.equals(this.getMemberIdBytes(), that.getMemberIdBytes());
        }

        public ClientProxyMembershipID getClientProxyID() {
            return ClientProxyMembershipID.this;
        }
    }
}

