/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.tier.sockets;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.ToDataException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LonerDistributionManager;
import com.gemstone.gemfire.distributed.internal.PooledExecutorWithDMStats;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SocketUtils;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.AllBucketProfilesUpdateMessage;
import com.gemstone.gemfire.internal.cache.tier.Acceptor;
import com.gemstone.gemfire.internal.cache.tier.CachedRegionHelper;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheServerStats;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientHealthMonitor;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConnectionListener;
import com.gemstone.gemfire.internal.cache.tier.sockets.ConnectionListenerAdapter;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerHandShakeProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewayReceiverStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.Logger;

public class AcceptorImpl
extends Acceptor
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private static final boolean isJRockit = System.getProperty("java.vm.name").contains("JRockit");
    protected final CacheServerStats stats;
    private final int maxConnections;
    private final int maxThreads;
    private final ThreadPoolExecutor pool;
    private final ThreadPoolExecutor hsPool;
    private final int localPort;
    private ServerSocket serverSock;
    protected final Cache cache;
    private final CachedRegionHelper crHelper;
    private final Object syncLock;
    private final Selector selector;
    private final LinkedBlockingQueue commBufferQueue;
    private final SystemTimer hsTimer;
    private final LinkedBlockingQueue selectorQueue;
    private final HashSet selectorRegistrations;
    private final boolean tcpNoDelay;
    public static final String HANDSHAKE_TIMEOUT_PROPERTY_NAME = "BridgeServer.handShakeTimeout";
    public static final int DEFAULT_HANDSHAKE_TIMEOUT_MS = 59000;
    protected static final int handShakeTimeout = Integer.getInteger("BridgeServer.handShakeTimeout", 59000);
    public static final String ACCEPT_TIMEOUT_PROPERTY_NAME = "BridgeServer.acceptTimeout";
    public static final int DEFAULT_ACCEPT_TIMEOUT_MS = 9900;
    private final int acceptTimeout;
    public static final int MINIMUM_MAX_CONNECTIONS = 16;
    private final int socketBufferSize;
    private final CacheClientNotifier clientNotifier;
    private static final int DEFAULT_BACKLOG = 1000;
    public static final String BACKLOG_PROPERTY_NAME = "BridgeServer.backlog";
    public final AtomicInteger clientServerCnxCount;
    private volatile boolean shutdown;
    private Thread thread;
    private Thread selectorThread;
    private final Object allSCsLock;
    private final HashSet allSCs;
    private volatile ServerConnection[] allSCList;
    private final String bindHostName;
    private final ConnectionListener connectionListener;
    private ClientHealthMonitor healthMonitor;
    private final boolean isSqlFabricHub;
    private final boolean notifyBySubscription;
    private long acceptorId;
    private static boolean isAuthenticationRequired;
    private static boolean isPostAuthzCallbackPresent;
    private boolean isGatewayReceiver;
    private List<GatewayTransportFilter> gatewayTransportFilters;
    @Deprecated
    private static final boolean DEPRECATED_SELECTOR;
    @Deprecated
    private static final int DEPRECATED_SELECTOR_POOL_SIZE;
    private static final int HANDSHAKE_POOL_SIZE;
    private static volatile boolean emergencyClassesLoaded;
    private static final boolean WORKAROUND_SELECTOR_BUG;
    private Selector tmpSel;
    private int registeredKeys;
    protected boolean loggedAcceptError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcceptorImpl(int port, String bindHostName, boolean notifyBySubscription, int socketBufferSize, int maximumTimeBetweenPings, Cache c, int maxConnections, int maxThreads, int maximumMessageCount, int messageTimeToLive, int transactionTimeToLive, ConnectionListener listener, List overflowAttributesList, boolean isSqlfStarted, boolean licenseClients, boolean isGatewayReceiver, boolean isGatewayHub, List<GatewayTransportFilter> transportFilter, boolean tcpNoDelay) throws IOException {
        InternalDistributedSystem ds;
        DM dm;
        int backLog;
        block42: {
            PrintWriter writer;
            StringWriter sw;
            this.serverSock = null;
            this.syncLock = new Object();
            this.acceptTimeout = Integer.getInteger(ACCEPT_TIMEOUT_PROPERTY_NAME, 9900);
            this.clientServerCnxCount = new AtomicInteger();
            this.shutdown = false;
            this.thread = null;
            this.selectorThread = null;
            this.allSCsLock = new Object();
            this.allSCs = new HashSet();
            this.allSCList = new ServerConnection[0];
            this.registeredKeys = 0;
            this.loggedAcceptError = false;
            this.bindHostName = AcceptorImpl.calcBindHostName(c, bindHostName);
            this.connectionListener = listener == null ? new ConnectionListenerAdapter() : listener;
            this.notifyBySubscription = notifyBySubscription;
            this.isSqlFabricHub = isSqlfStarted;
            this.isGatewayReceiver = isGatewayReceiver;
            this.gatewayTransportFilters = transportFilter;
            int tmp_maxConnections = maxConnections;
            if (tmp_maxConnections < 16) {
                tmp_maxConnections = 16;
            }
            this.maxConnections = tmp_maxConnections;
            int tmp_maxThreads = maxThreads;
            if (maxThreads == 0 && DEPRECATED_SELECTOR) {
                tmp_maxThreads = DEPRECATED_SELECTOR_POOL_SIZE;
            }
            if (tmp_maxThreads < 0) {
                tmp_maxThreads = 0;
            } else if (tmp_maxThreads > this.maxConnections) {
                tmp_maxThreads = this.maxConnections;
            }
            boolean isWindows = false;
            String os = System.getProperty("os.name");
            if (os != null && os.indexOf("Windows") != -1) {
                isWindows = true;
            }
            if (tmp_maxThreads > 0 && isWindows) {
                if (this.getBindAddress() instanceof Inet6Address) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_IGNORING_MAX_THREADS_DUE_TO_JROCKIT_NIO_BUG));
                    tmp_maxThreads = 0;
                }
                if (isJRockit) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_IGNORING_MAX_THREADS_DUE_TO_WINDOWS_IPV6_BUG));
                    tmp_maxThreads = 0;
                }
            }
            this.maxThreads = tmp_maxThreads;
            Selector tmp_s = null;
            LinkedBlockingQueue tmp_q = null;
            LinkedBlockingQueue tmp_commQ = null;
            HashSet tmp_hs = null;
            SystemTimer tmp_timer = null;
            if (this.isSelector()) {
                tmp_s = Selector.open();
                tmp_q = new LinkedBlockingQueue();
                tmp_commQ = new LinkedBlockingQueue();
                tmp_hs = new HashSet(512);
                tmp_timer = new SystemTimer(c.getDistributedSystem(), true);
            }
            this.selector = tmp_s;
            this.selectorQueue = tmp_q;
            this.commBufferQueue = tmp_commQ;
            this.selectorRegistrations = tmp_hs;
            this.hsTimer = tmp_timer;
            this.tcpNoDelay = tcpNoDelay;
            backLog = Integer.getInteger(BACKLOG_PROPERTY_NAME, 1000);
            SocketCreator sc = null;
            DistributionConfig config = ((InternalDistributedSystem)c.getDistributedSystem()).getConfig();
            if (!isGatewayReceiver && !isGatewayHub) {
                sc = SocketCreator.createNonDefaultInstance(config.getServerSSLEnabled(), config.getServerSSLRequireAuthentication(), config.getServerSSLProtocols(), config.getServerSSLCiphers(), config.getServerSSLProperties());
                if (config.getServerSSLEnabled()) {
                    sw = new StringWriter();
                    writer = new PrintWriter(sw);
                    config.getServerSSLProperties().list(writer);
                    logger.info("Starting CacheServer with SSL config : Authentication Required {} Ciphers {} Protocols {} Other Properties {} ", config.getServerSSLRequireAuthentication(), config.getServerSSLCiphers(), config.getServerSSLProtocols(), sw.toString());
                }
            } else {
                sc = SocketCreator.createNonDefaultInstance(config.getGatewaySSLEnabled(), config.getGatewaySSLRequireAuthentication(), config.getGatewaySSLProtocols(), config.getGatewaySSLCiphers(), config.getGatewaySSLProperties());
                if (config.getGatewaySSLEnabled()) {
                    sw = new StringWriter();
                    writer = new PrintWriter(sw);
                    config.getGatewaySSLProperties().list(writer);
                    logger.info("Starting Gateway with SSL config : Authentication Required {} Ciphers {} Protocols {} Other Properties {} ", config.getGatewaySSLRequireAuthentication(), config.getGatewaySSLCiphers(), config.getGatewaySSLProtocols(), sw.toString());
                }
            }
            GemFireCacheImpl gc2 = this.getCachedRegionHelper() != null ? (GemFireCacheImpl)this.getCachedRegionHelper().getCache() : null;
            long tilt = System.currentTimeMillis() + 120000L;
            if (this.isSelector()) {
                if (sc.useSSL()) {
                    throw new IllegalArgumentException(LocalizedStrings.AcceptorImpl_SELECTOR_THREAD_POOLING_CAN_NOT_BE_USED_WITH_CLIENTSERVER_SSL_THE_SELECTOR_CAN_BE_DISABLED_BY_SETTING_MAXTHREADS0.toLocalizedString());
                }
                ServerSocketChannel channel = ServerSocketChannel.open();
                this.serverSock = channel.socket();
                this.serverSock.setReuseAddress(true);
                this.serverSock.setReceiveBufferSize(socketBufferSize);
                while (true) {
                    try {
                        this.serverSock.bind(new InetSocketAddress(this.getBindAddress(), port), backLog);
                        break block42;
                    }
                    catch (SocketException b) {
                        if (!AcceptorImpl.treatAsBindException(b) || System.currentTimeMillis() > tilt) {
                            throw b;
                        }
                        boolean interrupted = Thread.interrupted();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                        finally {
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (gc2 == null) continue;
                        gc2.getCancelCriterion().checkCancelInProgress(null);
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    this.serverSock = sc.createServerSocket(port, backLog, this.getBindAddress(), this.gatewayTransportFilters, socketBufferSize);
                }
                catch (SocketException e) {
                    if (!AcceptorImpl.treatAsBindException(e) || System.currentTimeMillis() > tilt) {
                        throw e;
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e2) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (gc2 == null) continue;
                    gc2.getCancelCriterion().checkCancelInProgress(null);
                    continue;
                }
                break;
            }
        }
        if (port == 0) {
            port = this.serverSock.getLocalPort();
        }
        if ((dm = (ds = InternalDistributedSystem.getConnectedInstance()).getDistributionManager()).getDistributionManagerId().getPort() == 0 && dm instanceof LonerDistributionManager) {
            ((LonerDistributionManager)dm).updateLonerPort(port);
        }
        this.localPort = port;
        String sockName = this.serverSock.getLocalSocketAddress().toString();
        logger.info(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_CONNECTION_LISTENER_BOUND_TO_ADDRESS_0_WITH_BACKLOG_1, new Object[]{sockName, backLog}));
        this.stats = isGatewayReceiver ? GatewayReceiverStats.createGatewayReceiverStats(sockName) : new CacheServerStats(sockName);
        this.cache = c;
        this.crHelper = new CachedRegionHelper(this.cache);
        this.clientNotifier = CacheClientNotifier.getInstance(this.cache, this.stats, maximumMessageCount, messageTimeToLive, transactionTimeToLive, this.connectionListener, overflowAttributesList, isGatewayReceiver);
        this.socketBufferSize = socketBufferSize;
        this.healthMonitor = ClientHealthMonitor.getInstance(c, maximumTimeBetweenPings, this.clientNotifier.getStats(), licenseClients);
        ThreadPoolExecutor tmp_pool = null;
        String gName = "ServerConnection on port " + this.localPort;
        final LoggingThreadGroup socketThreadGroup = LoggingThreadGroup.createThreadGroup(gName, logger);
        ThreadFactory socketThreadFactory = new ThreadFactory(){
            int connNum = -1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(final Runnable command) {
                int tnum;
                1 var3_2 = this;
                synchronized (var3_2) {
                    tnum = ++this.connNum;
                }
                String tName = socketThreadGroup.getName() + " Thread " + tnum;
                AcceptorImpl.this.getStats().incConnectionThreadsCreated();
                Runnable r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            command.run();
                        }
                        catch (CancelException cancelException) {
                        }
                        finally {
                            ConnectionTable.releaseThreadsSockets();
                        }
                    }
                };
                return new Thread(socketThreadGroup, r, tName);
            }
        };
        try {
            tmp_pool = this.isSelector() ? new PooledExecutorWithDMStats(new LinkedBlockingQueue<Runnable>(), this.maxThreads, this.getStats().getCnxPoolHelper(), socketThreadFactory, Integer.MAX_VALUE) : new ThreadPoolExecutor(16, this.maxConnections, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), socketThreadFactory);
        }
        catch (IllegalArgumentException poolInitException) {
            this.stats.close();
            this.serverSock.close();
            throw poolInitException;
        }
        this.pool = tmp_pool;
        ThreadPoolExecutor tmp_hsPool = null;
        gName = "Handshaker " + this.serverSock.getInetAddress() + ":" + this.localPort;
        socketThreadGroup = LoggingThreadGroup.createThreadGroup(gName, logger);
        socketThreadFactory = new ThreadFactory(){
            int connNum = -1;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(Runnable command) {
                int tnum;
                2 var3_2 = this;
                synchronized (var3_2) {
                    tnum = ++this.connNum;
                }
                String tName = socketThreadGroup.getName() + " Thread " + tnum;
                AcceptorImpl.this.getStats().incAcceptThreadsCreated();
                return new Thread(socketThreadGroup, command, tName);
            }
        };
        try {
            final SynchronousQueue<Runnable> bq = new SynchronousQueue<Runnable>();
            RejectedExecutionHandler reh = new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor pool) {
                    try {
                        bq.put(r);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        throw new RejectedExecutionException(LocalizedStrings.AcceptorImpl_INTERRUPTED.toLocalizedString(), ex);
                    }
                }
            };
            tmp_hsPool = new ThreadPoolExecutor(1, HANDSHAKE_POOL_SIZE, 60L, TimeUnit.SECONDS, bq, socketThreadFactory, reh);
        }
        catch (IllegalArgumentException poolInitException) {
            this.stats.close();
            this.serverSock.close();
            this.pool.shutdownNow();
            throw poolInitException;
        }
        this.hsPool = tmp_hsPool;
        String authenticator = this.cache.getDistributedSystem().getProperties().getProperty("security-client-authenticator");
        isAuthenticationRequired = authenticator != null && authenticator.length() > 0;
        String postAuthzFactoryName = this.cache.getDistributedSystem().getProperties().getProperty("security-client-accessor-pp");
        isPostAuthzCallbackPresent = postAuthzFactoryName != null && postAuthzFactoryName.length() > 0;
    }

    public long getAcceptorId() {
        return this.acceptorId;
    }

    public CacheServerStats getStats() {
        return this.stats;
    }

    public boolean isSelector() {
        return this.maxThreads > 0;
    }

    @Override
    public void start() throws IOException {
        LoggingThreadGroup tg = LoggingThreadGroup.createThreadGroup("Acceptor " + this.serverSock.getInetAddress() + ":" + this.localPort, logger);
        this.thread = new Thread(tg, this, "Cache Server Acceptor " + this.serverSock.getInetAddress() + ":" + this.localPort + " local port: " + this.serverSock.getLocalPort());
        this.acceptorId = this.thread.getId();
        this.thread.start();
        if (this.isSelector()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AcceptorImpl.this.runSelectorLoop();
                }
            };
            this.selectorThread = new Thread(tg, r, "Cache Server Selector " + this.serverSock.getInetAddress() + ":" + this.localPort + " local port: " + this.serverSock.getLocalPort());
            this.selectorThread.start();
        }
        GemFireCacheImpl myCache = (GemFireCacheImpl)this.cache;
        Set<PartitionedRegion> prs = myCache.getPartitionedRegions();
        for (PartitionedRegion pr2 : prs) {
            HashMap<Integer, BucketAdvisor.BucketProfile> profiles = new HashMap<Integer, BucketAdvisor.BucketProfile>();
            Map<Integer, BucketAdvisor> advisors = pr2.getRegionAdvisor().getAllBucketAdvisors();
            for (Map.Entry<Integer, BucketAdvisor> entry : advisors.entrySet()) {
                BucketAdvisor advisor = entry.getValue();
                BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)advisor.createProfile();
                advisor.updateServerBucketProfile(bp);
                profiles.put(entry.getKey(), bp);
            }
            Set receipients = new HashSet();
            receipients = pr2.getRegionAdvisor().adviseAllPRNodes();
            ReplyProcessor21 reply = AllBucketProfilesUpdateMessage.send(receipients, pr2.getDistributionManager(), pr2.getPRId(), profiles, true);
            if (reply == null) continue;
            reply.waitForRepliesUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSC(ServerConnection sc) {
        Object object = this.syncLock;
        synchronized (object) {
            if (!this.isRunning()) {
                this.finishCon(sc);
                return;
            }
        }
        this.getSelectorQueue().offer(sc);
        this.wakeupSelector();
    }

    private void wakeupSelector() {
        Selector s = this.getSelector();
        if (s != null && s.isOpen()) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSC(ServerConnection sc) {
        Object object = this.allSCsLock;
        synchronized (object) {
            this.allSCs.remove(sc);
            Iterator it = this.allSCs.iterator();
            ServerConnection[] again = new ServerConnection[this.allSCs.size()];
            for (int i = 0; i < again.length; ++i) {
                again[i] = (ServerConnection)it.next();
            }
            this.allSCList = again;
        }
        if (!this.isRunning()) {
            return;
        }
        this.wakeupSelector();
    }

    private void finishCon(ServerConnection sc) {
        if (sc != null) {
            sc.handleTermination();
        }
    }

    private void drainSelectorQueue() {
        ServerConnection sc = (ServerConnection)this.selectorQueue.poll();
        CancelException cce = null;
        while (sc != null) {
            block7: {
                try {
                    this.finishCon(sc);
                }
                catch (CancelException e) {
                    if (cce != null) break block7;
                    cce = e;
                }
            }
            sc = (ServerConnection)this.selectorQueue.poll();
        }
        Iterator it = this.selectorRegistrations.iterator();
        while (it.hasNext()) {
            try {
                this.finishCon((ServerConnection)it.next());
            }
            catch (CancelException e) {
                if (cce != null) continue;
                cce = e;
            }
        }
        if (cce != null) {
            throw cce;
        }
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        CachedRegionHelper.loadEmergencyClasses();
        ServerConnection.loadEmergencyClasses();
    }

    public void emergencyClose() {
        ServerSocket ss = this.serverSock;
        if (ss != null) {
            try {
                ss.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.crHelper.setShutdown(true);
        ServerConnection[] snap = this.allSCList;
        for (int i = 0; i < snap.length; ++i) {
            snap[i].emergencyClose();
        }
    }

    private boolean isRegisteredObjectClosed(ServerConnection sc) {
        return sc.isClosed();
    }

    private int checkRegisteredKeys(int count) {
        int result = count;
        CancelException cce = null;
        if (count > 0) {
            Iterator it = this.selectorRegistrations.iterator();
            while (it.hasNext()) {
                ServerConnection sc = (ServerConnection)it.next();
                if (!this.isRegisteredObjectClosed(sc)) continue;
                --result;
                it.remove();
                try {
                    this.finishCon(sc);
                }
                catch (CancelException e) {
                    if (cce != null) continue;
                    cce = e;
                }
            }
        }
        if (cce != null) {
            throw cce;
        }
        return result;
    }

    private void checkForStuckKeys() {
        if (!WORKAROUND_SELECTOR_BUG) {
            return;
        }
        if (this.tmpSel == null) {
            try {
                this.tmpSel = Selector.open();
            }
            catch (IOException ignore) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_COULD_NOT_CHECK_FOR_STUCK_KEYS, ignore));
                return;
            }
        }
        for (SelectionKey sk : new ArrayList<SelectionKey>(this.selector.keys())) {
            ServerConnection sc = (ServerConnection)sk.attachment();
            if (sc == null) continue;
            try {
                sk.cancel();
                this.selector.selectNow();
                SelectionKey tmpsk = sc.getSelectableChannel().register(this.tmpSel, 5);
                try {
                    int events = this.tmpSel.selectNow();
                    if (events == 0) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_STUCK_SELECTION_KEY_DETECTED_ON_0, sc));
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                        sc.registerWithSelector2(this.selector);
                        continue;
                    }
                    if (tmpsk.isValid() && tmpsk.isReadable()) {
                        try {
                            tmpsk.cancel();
                            this.tmpSel.selectNow();
                            this.selectorRegistrations.remove(sc);
                            --this.registeredKeys;
                            sc.makeBlocking();
                            sc.setProcessingMessage();
                        }
                        catch (ClosedChannelException ignore) {
                            this.finishCon(sc);
                            continue;
                        }
                        catch (IOException ex) {
                            this.finishCon(sc);
                            if (!this.isRunning()) continue;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED_EXCEPTION, ex));
                            continue;
                        }
                        try {
                            this.stats.incThreadQueueSize();
                            this.pool.execute(sc);
                        }
                        catch (RejectedExecutionException rejected) {
                            this.finishCon(sc);
                            this.stats.decThreadQueueSize();
                            if (!this.isRunning()) break;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED_EXCEPTION, rejected));
                        }
                        continue;
                    }
                    if (tmpsk.isValid() && tmpsk.isWritable()) {
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                        sc.registerWithSelector2(this.selector);
                        continue;
                    }
                    if (tmpsk.isValid()) continue;
                    tmpsk.cancel();
                    this.tmpSel.selectNow();
                    sc.registerWithSelector2(this.selector);
                }
                catch (IOException ex) {
                    if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED_EXCEPTION, ex));
                    try {
                        tmpsk.cancel();
                        this.tmpSel.selectNow();
                    }
                    catch (IOException ex2) {
                        if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                        logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED_EXCEPTION, ex2));
                    }
                }
            }
            catch (ClosedChannelException ignore) {
                this.finishCon(sc);
            }
            catch (IOException ex) {
                if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED_EXCEPTION, ex));
            }
            catch (NullPointerException npe) {
                if (!this.isRunning() || !this.selector.isOpen() || !this.tmpSel.isOpen()) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED_EXCEPTION, npe));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSelectorLoop() {
        try {
            logger.info(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_SELECTOR_ENABLED));
            block32: while (this.selector.isOpen() && !Thread.currentThread().isInterrupted()) {
                SystemFailure.checkFailure();
                if (((GemFireCacheImpl)this.cache).isClosed()) {
                    break;
                }
                if (this.cache.getCancelCriterion().cancelInProgress() != null) {
                    break;
                }
                this.registeredKeys = this.checkRegisteredKeys(this.registeredKeys);
                ServerConnection sc = this.registeredKeys == 0 ? (ServerConnection)this.selectorQueue.take() : (ServerConnection)this.selectorQueue.poll();
                while (sc != null) {
                    try {
                        sc.registerWithSelector2(this.selector);
                        ++this.registeredKeys;
                        this.selectorRegistrations.add(sc);
                    }
                    catch (ClosedChannelException cce) {
                        this.finishCon(sc);
                    }
                    catch (IOException ex) {
                        this.finishCon(sc);
                        logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_IGNORING, ex));
                    }
                    catch (RuntimeException ex) {
                        this.finishCon(sc);
                        logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_IGNORING, ex));
                    }
                    sc = (ServerConnection)this.selectorQueue.poll();
                }
                if (this.registeredKeys == 0) continue;
                int events = this.selector.select();
                if (this.cache.getCancelCriterion().cancelInProgress() != null) {
                    break;
                }
                if (events == 0) {
                    this.checkForStuckKeys();
                }
                while (events > 0) {
                    int cancelCount = 0;
                    Set<SelectionKey> sk = this.selector.selectedKeys();
                    if (sk == null) {
                        events = 0;
                        continue block32;
                    }
                    Iterator<SelectionKey> keysIterator = sk.iterator();
                    while (keysIterator.hasNext()) {
                        SelectionKey key2 = keysIterator.next();
                        keysIterator.remove();
                        ServerConnection sc2 = (ServerConnection)key2.attachment();
                        try {
                            if (key2.isValid() && key2.isReadable()) {
                                try {
                                    key2.cancel();
                                    this.selectorRegistrations.remove(sc2);
                                    --this.registeredKeys;
                                    ++cancelCount;
                                    sc2.makeBlocking();
                                    sc2.setProcessingMessage();
                                }
                                catch (ClosedChannelException ignore) {
                                    this.finishCon(sc2);
                                    continue;
                                }
                                catch (IOException ex) {
                                    this.finishCon(sc2);
                                    if (!this.isRunning()) continue;
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED, ex));
                                    continue;
                                }
                                try {
                                    this.stats.incThreadQueueSize();
                                    this.pool.execute(sc2);
                                }
                                catch (RejectedExecutionException rejected) {
                                    this.finishCon(sc2);
                                    this.stats.decThreadQueueSize();
                                    if (!this.isRunning()) break;
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED, rejected));
                                }
                                continue;
                            }
                            this.finishCon(sc2);
                            if (!key2.isValid()) continue;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_IGNORING_EVENT_ON_SELECTOR_KEY__0, key2));
                        }
                        catch (CancelledKeyException ex) {
                            this.finishCon(sc2);
                        }
                    }
                    if (cancelCount > 0 && this.selector.isOpen()) {
                        events = this.selector.selectNow();
                        continue;
                    }
                    events = 0;
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ClosedSelectorException ex) {
            try {
                this.drainSelectorQueue();
            }
            finally {
                this.close();
            }
        }
        catch (IOException ex) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED, ex));
        }
        finally {
            try {
                this.drainSelectorQueue();
            }
            finally {
                this.close();
            }
        }
    }

    @Override
    public int getPort() {
        return this.localPort;
    }

    public InetAddress getServerInetAddr() {
        return this.serverSock.getInetAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.accept();
        }
        catch (CancelException e) {
        }
        finally {
            try {
                if (this.serverSock != null) {
                    this.serverSock.close();
                }
            }
            catch (IOException ignore) {}
            if (this.stats != null) {
                this.stats.close();
            }
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    public BlockingQueue getSelectorQueue() {
        return this.selectorQueue;
    }

    protected static void closeSocket(Socket s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept() {
        while (this.isRunning()) {
            Closeable s;
            if (SystemFailure.getFailure() != null) {
                s = this.serverSock;
                if (s != null) {
                    try {
                        ((ServerSocket)s).close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                SystemFailure.checkFailure();
            }
            this.crHelper.checkCancelInProgress(null);
            s = null;
            try {
                s = this.serverSock.accept();
                this.crHelper.checkCancelInProgress(null);
                ((Socket)s).setKeepAlive(SocketCreator.ENABLE_TCP_KEEP_ALIVE);
                if (this.crHelper.emulateSlowServer() > 0) {
                    try {
                        Thread.sleep(this.crHelper.emulateSlowServer());
                    }
                    catch (InterruptedException ugh) {
                        // empty catch block
                    }
                }
                Object ugh = this.syncLock;
                synchronized (ugh) {
                    if (!this.isRunning()) {
                        AcceptorImpl.closeSocket((Socket)s);
                        break;
                    }
                }
                SocketCreator.getDefaultInstance().configureServerSSLSocket((Socket)s);
                this.loggedAcceptError = false;
                this.handOffNewClientConnection((Socket)s);
            }
            catch (InterruptedIOException e) {
                AcceptorImpl.closeSocket((Socket)s);
                if (!this.isRunning() || !logger.isDebugEnabled()) continue;
                logger.debug("Aborted due to interrupt: {}", (Throwable)e);
            }
            catch (IOException e) {
                block20: {
                    if (this.isRunning() && e instanceof SSLException) {
                        try {
                            ServerHandShakeProcessor.refuse(((Socket)s).getOutputStream(), e.toString(), (byte)63);
                        }
                        catch (IOException ex) {
                            if (!logger.isDebugEnabled()) break block20;
                            logger.debug("Bridge server: Unable to write SSL error");
                        }
                    }
                }
                AcceptorImpl.closeSocket((Socket)s);
                if (!this.isRunning() || this.loggedAcceptError) continue;
                this.loggedAcceptError = true;
                logger.error(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_UNEXPECTED_IOEXCEPTION_FROM_ACCEPT, e));
            }
            catch (CancelException e) {
                AcceptorImpl.closeSocket((Socket)s);
                throw e;
            }
            catch (Exception e) {
                AcceptorImpl.closeSocket((Socket)s);
                if (!this.isRunning()) continue;
                logger.fatal(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_UNEXPECTED_EXCEPTION, e));
            }
        }
    }

    private void handOffNewClientConnection(final Socket s) {
        block2: {
            try {
                this.stats.incAcceptsInProgress();
                this.hsPool.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean finished = false;
                        try {
                            AcceptorImpl.this.handleNewClientConnection(s);
                            finished = true;
                        }
                        catch (RegionDestroyedException rde) {
                            if (rde.getMessage().indexOf("HARegion") == -1) {
                                throw rde;
                            }
                        }
                        catch (CancelException e) {
                        }
                        catch (AsynchronousCloseException expected) {
                        }
                        catch (ToDataException | IOException ex) {
                            if (AcceptorImpl.this.isRunning() && !AcceptorImpl.this.loggedAcceptError) {
                                AcceptorImpl.this.loggedAcceptError = true;
                                if (ex instanceof SocketTimeoutException) {
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_FAILED_ACCEPTING_CLIENT_CONNECTION_DUE_TO_SOCKET_TIMEOUT));
                                } else {
                                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_FAILED_ACCEPTING_CLIENT_CONNECTION__0, ex), (Throwable)ex);
                                }
                            }
                        }
                        finally {
                            if (!finished) {
                                AcceptorImpl.closeSocket(s);
                            }
                            if (AcceptorImpl.this.isRunning()) {
                                AcceptorImpl.this.stats.decAcceptsInProgress();
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException rejected) {
                AcceptorImpl.closeSocket(s);
                if (!this.isRunning()) break block2;
                this.stats.decAcceptsInProgress();
                logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED, rejected));
            }
        }
    }

    public ByteBuffer takeCommBuffer() {
        ByteBuffer result = (ByteBuffer)this.commBufferQueue.poll();
        if (result == null) {
            result = ByteBuffer.allocateDirect(this.socketBufferSize);
        }
        return result;
    }

    public void releaseCommBuffer(ByteBuffer bb) {
        if (bb == null) {
            return;
        }
        if (this.isRunning()) {
            this.commBufferQueue.offer(bb);
        }
    }

    public void incClientServerCnxCount() {
        this.clientServerCnxCount.incrementAndGet();
    }

    public void decClientServerCnxCount() {
        this.clientServerCnxCount.decrementAndGet();
    }

    public int getClientServerCnxCount() {
        return this.clientServerCnxCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewClientConnection(final Socket s) throws IOException {
        byte communicationMode;
        if (this.isSelector()) {
            ByteBuffer bb = ByteBuffer.allocateDirect(1);
            SocketChannel sc = s.getChannel();
            sc.configureBlocking(false);
            int res = sc.read(bb);
            sc.configureBlocking(true);
            if (res < 0) {
                throw new EOFException();
            }
            if (res == 0) {
                SystemTimer.SystemTimerTask st = new SystemTimer.SystemTimerTask(){

                    @Override
                    public void run2() {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_TIMED_OUT_WAITING_FOR_HANDSHAKE_FROM__0, s.getRemoteSocketAddress()));
                        AcceptorImpl.closeSocket(s);
                    }
                };
                this.hsTimer.schedule(st, this.acceptTimeout);
                res = sc.read(bb);
                if (!st.cancel() || res <= 0) {
                    throw new EOFException();
                }
            }
            communicationMode = bb.get(0);
            if (logger.isTraceEnabled()) {
                logger.trace("read communications mode(1) ", communicationMode);
            }
        } else {
            s.setSoTimeout(this.acceptTimeout);
            communicationMode = (byte)SocketUtils.getInputStream(s).read();
            if (logger.isTraceEnabled()) {
                logger.trace("read communications mode(2) ", communicationMode);
            }
            if (communicationMode == -1) {
                throw new EOFException();
            }
            s.setSoTimeout(0);
        }
        s.setTcpNoDelay(this.tcpNoDelay);
        if (communicationMode == 100 || communicationMode == 103 || communicationMode == 104 || communicationMode == 107) {
            int curCnt;
            String communicationModeStr = "";
            switch (communicationMode) {
                case 100: {
                    communicationModeStr = "client";
                    break;
                }
                case 103: {
                    communicationModeStr = "gateway";
                    break;
                }
                case 104: {
                    communicationModeStr = "monitor";
                    break;
                }
                case 107: {
                    communicationModeStr = "clientToServerForQueue";
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Bridge server: Initializing {} communication socket: {}", communicationModeStr, s);
            }
            if (communicationMode != 107 && (curCnt = this.getClientServerCnxCount()) >= this.maxConnections) {
                block37: {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_REJECTED_CONNECTION_FROM_0_BECAUSE_CURRENT_CONNECTION_COUNT_OF_1_IS_GREATER_THAN_OR_EQUAL_TO_THE_CONFIGURED_MAX_OF_2, new Object[]{s.getInetAddress(), curCnt, this.maxConnections}));
                    try {
                        ServerHandShakeProcessor.refuse(s.getOutputStream(), LocalizedStrings.AcceptorImpl_EXCEEDED_MAX_CONNECTIONS_0.toLocalizedString(this.maxConnections));
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block37;
                        logger.debug("rejection message failed", (Throwable)ex);
                    }
                }
                AcceptorImpl.closeSocket(s);
                return;
            }
            ServerConnection serverConn = new ServerConnection(s, this.cache, this.crHelper, this.stats, handShakeTimeout, this.socketBufferSize, communicationModeStr, communicationMode, this);
            Object ex = this.allSCsLock;
            synchronized (ex) {
                this.allSCs.add(serverConn);
                Object[] snap = this.allSCList;
                this.allSCList = (ServerConnection[])ArrayUtils.insert(snap, snap.length, serverConn);
            }
            if (communicationMode != 107) {
                this.incClientServerCnxCount();
            }
            if (this.isSelector()) {
                serverConn.registerWithSelector();
            } else {
                try {
                    this.pool.execute(serverConn);
                }
                catch (RejectedExecutionException rejected) {
                    block38: {
                        if (!this.isRunning()) {
                            return;
                        }
                        logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_REJECTED_CONNECTION_FROM_0_BECAUSE_REQUEST_REJECTED_BY_POOL, new Object[]{serverConn}));
                        try {
                            ServerHandShakeProcessor.refuse(s.getOutputStream(), LocalizedStrings.AcceptorImpl_EXCEEDED_MAX_CONNECTIONS_0.toLocalizedString(this.maxConnections));
                        }
                        catch (Exception ex2) {
                            if (!logger.isDebugEnabled()) break block38;
                            logger.debug("rejection message failed", (Throwable)ex2);
                        }
                    }
                    serverConn.cleanup();
                }
            }
        } else if (communicationMode == 101) {
            if (logger.isDebugEnabled()) {
                logger.debug(":Bridge server: Initializing primary server-to-client communication socket: {}", s);
            }
            this.clientNotifier.registerClient(s, true, this.acceptorId, this.notifyBySubscription);
        } else if (communicationMode == 102) {
            if (logger.isDebugEnabled()) {
                logger.debug(":Bridge server: Initializing secondary server-to-client communication socket: {}", s);
            }
            this.clientNotifier.registerClient(s, false, this.acceptorId, this.notifyBySubscription);
        } else {
            throw new IOException("Acceptor received unknown communication mode: " + communicationMode);
        }
    }

    @Override
    public boolean isRunning() {
        return !this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Allow this thread to die")
    public void close() {
        if (!this.isRunning()) {
            return;
        }
        try {
            Object object = this.syncLock;
            synchronized (object) {
                this.shutdown = true;
                logger.info(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_BRIDGE_SERVER_ON_PORT_0_IS_SHUTTING_DOWN, this.localPort));
                if (this.thread != null) {
                    this.thread.interrupt();
                }
                this.serverSock.close();
                this.crHelper.setShutdown(true);
                if (this.isSelector()) {
                    this.hsTimer.cancel();
                    if (this.tmpSel != null) {
                        try {
                            this.tmpSel.close();
                        }
                        catch (IOException ignore) {
                            // empty catch block
                        }
                    }
                    try {
                        this.wakeupSelector();
                        this.selector.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    if (this.selectorThread != null) {
                        this.selectorThread.interrupt();
                    }
                    this.commBufferQueue.clear();
                }
                ClientHealthMonitor.shutdownInstance();
                this.shutdownSCs();
                this.clientNotifier.shutdown(this.acceptorId);
                this.pool.shutdown();
                if (!this.pool.awaitTermination(PoolImpl.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS)) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.PoolImpl_TIMEOUT_WAITING_FOR_BACKGROUND_TASKS_TO_COMPLETE));
                    this.pool.shutdownNow();
                }
                this.hsPool.shutdownNow();
                this.stats.close();
                GemFireCacheImpl myCache = (GemFireCacheImpl)this.cache;
                Set<PartitionedRegion> prs = myCache.getPartitionedRegions();
                for (PartitionedRegion pr2 : prs) {
                    HashMap<Integer, BucketAdvisor.BucketProfile> profiles = new HashMap<Integer, BucketAdvisor.BucketProfile>();
                    Map<Integer, BucketAdvisor> advisors = pr2.getRegionAdvisor().getAllBucketAdvisors();
                    for (Map.Entry<Integer, BucketAdvisor> entry : advisors.entrySet()) {
                        BucketAdvisor advisor = entry.getValue();
                        BucketAdvisor.BucketProfile bp = (BucketAdvisor.BucketProfile)advisor.createProfile();
                        advisor.updateServerBucketProfile(bp);
                        profiles.put(entry.getKey(), bp);
                    }
                    Set receipients = new HashSet();
                    receipients = pr2.getRegionAdvisor().adviseAllPRNodes();
                    ReplyProcessor21 reply = AllBucketProfilesUpdateMessage.send(receipients, pr2.getDistributionManager(), pr2.getPRId(), profiles, true);
                    if (reply != null) {
                        reply.waitForRepliesUninterruptibly();
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("sending messages to all peers for removing this server..");
                }
            }
        }
        catch (Exception e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.AcceptorImpl_UNEXPECTED), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownSCs() {
        Object object = this.allSCsLock;
        synchronized (object) {
            ServerConnection[] snap = this.allSCList;
            for (int i = 0; i < snap.length; ++i) {
                snap[i].cleanup();
            }
        }
    }

    private static String calcBindHostName(Cache cache, String bindName) {
        if (bindName != null && !bindName.equals("")) {
            return bindName;
        }
        InternalDistributedSystem system = (InternalDistributedSystem)cache.getDistributedSystem();
        DistributionConfig config = system.getConfig();
        String hostName = null;
        String serverBindAddress = config.getServerBindAddress();
        if (serverBindAddress != null && serverBindAddress.length() > 0) {
            hostName = serverBindAddress;
        } else {
            String bindAddress = config.getBindAddress();
            if (bindAddress != null && bindAddress.length() > 0) {
                hostName = bindAddress;
            }
        }
        return hostName;
    }

    private InetAddress getBindAddress() throws IOException {
        if (this.bindHostName == null || "".equals(this.bindHostName)) {
            return null;
        }
        return InetAddress.getByName(this.bindHostName);
    }

    public String getExternalAddress() {
        String result = this.bindHostName;
        boolean needCanonicalHostName = false;
        if (result == null || "".equals(result)) {
            needCanonicalHostName = true;
        } else {
            InetSocketAddress isa;
            InetAddress ssAddr;
            ServerSocket ss = this.serverSock;
            if (ss != null && ss.getLocalSocketAddress() instanceof InetSocketAddress && (ssAddr = (isa = (InetSocketAddress)ss.getLocalSocketAddress()).getAddress()) != null && ssAddr.isAnyLocalAddress()) {
                needCanonicalHostName = true;
            }
        }
        if (needCanonicalHostName) {
            try {
                result = SocketCreator.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ex) {
                throw new IllegalStateException("getLocalHost failed with " + ex);
            }
        }
        return result;
    }

    public CacheClientNotifier getCacheClientNotifier() {
        return this.clientNotifier;
    }

    public CachedRegionHelper getCachedRegionHelper() {
        return this.crHelper;
    }

    public ClientHealthMonitor getClientHealthMonitor() {
        return this.healthMonitor;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public boolean isSqlFabricSystem() {
        return this.isSqlFabricHub;
    }

    public boolean isGatewayReceiver() {
        return this.isGatewayReceiver;
    }

    public List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    public static boolean treatAsBindException(SocketException se) {
        if (se instanceof BindException) {
            return true;
        }
        String msg = se.getMessage();
        return msg != null && msg.contains("Invalid argument: listen failed");
    }

    public static boolean isAuthenticationRequired() {
        return isAuthenticationRequired;
    }

    public static boolean isPostAuthzCallbackPresent() {
        return isPostAuthzCallbackPresent;
    }

    public Set<ServerConnection> getAllServerConnections() {
        return Collections.unmodifiableSet(this.allSCs);
    }

    public ServerConnection[] getAllServerConnectionList() {
        return this.allSCList;
    }

    static {
        DEPRECATED_SELECTOR = Boolean.getBoolean("BridgeServer.SELECTOR");
        DEPRECATED_SELECTOR_POOL_SIZE = Integer.getInteger("BridgeServer.SELECTOR_POOL_SIZE", 16);
        HANDSHAKE_POOL_SIZE = Integer.getInteger("BridgeServer.HANDSHAKE_POOL_SIZE", 4);
        emergencyClassesLoaded = false;
        WORKAROUND_SELECTOR_BUG = Boolean.getBoolean("CacheServer.NIO_SELECTOR_WORKAROUND");
    }
}

