/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.snapshot;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.snapshot.SnapshotIterator;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.snapshot.ExportedRegistry;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotPacket;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;

public class GFSnapshot {
    public static final int SNAP_VER_1 = 1;
    public static final int SNAP_VER_2 = 2;
    private static final byte[] SNAP_FMT = new byte[]{71, 70, 83};

    private GFSnapshot() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: GFSnapshot <file>");
            System.exit(1);
        }
        try (GFSnapshotImporter imp = new GFSnapshotImporter(new File(args[0]));){
            SnapshotPacket.SnapshotRecord record;
            System.out.println("Snapshot format is version " + imp.getVersion());
            System.out.println("Snapshot region is " + imp.getRegionName());
            ExportedRegistry reg = imp.getPdxTypes();
            Map<Integer, PdxType> types = reg.types();
            System.out.println("Found " + types.size() + " PDX types:");
            for (Map.Entry<Integer, PdxType> entry : types.entrySet()) {
                System.out.println("\t" + entry.getKey() + " = " + entry.getValue());
            }
            Map<Integer, EnumInfo> enums = reg.enums();
            System.out.println("Found " + enums.size() + " PDX enums: ");
            for (Map.Entry<Integer, EnumInfo> entry : enums.entrySet()) {
                System.out.println("\t" + entry.getKey() + " = " + entry.getValue());
            }
            System.out.println();
            while ((record = imp.readSnapshotRecord()) != null) {
                System.out.println(record.getKeyObject() + " = " + record.getValueObject());
            }
        }
    }

    public static SnapshotWriter create(File snapshot, String region) throws IOException {
        final GFSnapshotExporter out = new GFSnapshotExporter(snapshot, region);
        return new SnapshotWriter(){

            @Override
            public void snapshotEntry(SnapshotPacket.SnapshotRecord entry) throws IOException {
                out.writeSnapshotEntry(entry);
            }

            @Override
            public void snapshotComplete() throws IOException {
                out.close();
            }
        };
    }

    public static <K, V> SnapshotIterator<K, V> read(final File snapshot) throws IOException, ClassNotFoundException {
        return new SnapshotIterator<K, V>(){
            GFSnapshotImporter in;
            private boolean foundNext;
            private Map.Entry<K, V> next;
            {
                this.in = new GFSnapshotImporter(snapshot);
            }

            @Override
            public boolean hasNext() throws IOException, ClassNotFoundException {
                if (!this.foundNext) {
                    return this.moveNext();
                }
                return true;
            }

            @Override
            public Map.Entry<K, V> next() throws IOException, ClassNotFoundException {
                if (!this.foundNext && !this.moveNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry result = this.next;
                this.foundNext = false;
                this.next = null;
                return result;
            }

            @Override
            public void close() throws IOException {
                this.in.close();
            }

            private boolean moveNext() throws IOException, ClassNotFoundException {
                SnapshotPacket.SnapshotRecord record = this.in.readSnapshotRecord();
                if (record != null) {
                    this.foundNext = true;
                    final Object key2 = record.getKeyObject();
                    final Object value2 = record.getValueObject();
                    this.next = new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return key2;
                        }

                        @Override
                        public V getValue() {
                            return value2;
                        }

                        @Override
                        public V setValue(V value22) {
                            throw new UnsupportedOperationException();
                        }
                    };
                    return true;
                }
                this.close();
                return false;
            }
        };
    }

    static class GFSnapshotImporter {
        private final byte version;
        private final String region;
        private final ExportedRegistry pdx;
        private final DataInputStream dis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GFSnapshotImporter(File in) throws IOException, ClassNotFoundException {
            long entryPosition;
            block7: {
                this.pdx = new ExportedRegistry();
                FileInputStream fis = new FileInputStream(in);
                FileChannel fc = fis.getChannel();
                try (DataInputStream tmp = new DataInputStream(fis);){
                    this.version = tmp.readByte();
                    if (this.version == 1) {
                        throw new IOException(LocalizedStrings.Snapshot_UNSUPPORTED_SNAPSHOT_VERSION_0.toLocalizedString(1) + ": " + in);
                    }
                    if (this.version == 2) {
                        byte[] format = new byte[3];
                        tmp.readFully(format);
                        if (!Arrays.equals(format, SNAP_FMT)) {
                            throw new IOException(LocalizedStrings.Snapshot_UNRECOGNIZED_FILE_TYPE_0.toLocalizedString(Arrays.toString(format)) + ": " + in);
                        }
                        long registryPosition = tmp.readLong();
                        this.region = tmp.readUTF();
                        entryPosition = fc.position();
                        if (registryPosition != -1L) {
                            fc.position(registryPosition);
                            this.pdx.fromData(tmp);
                        }
                        break block7;
                    }
                    throw new IOException(LocalizedStrings.Snapshot_UNRECOGNIZED_FILE_VERSION_0.toLocalizedString(this.version) + ": " + in);
                }
            }
            this.checkPdxTypeCompatibility();
            this.checkPdxEnumCompatibility();
            this.dis = new DataInputStream(new BufferedInputStream(new FileInputStream(in)));
            this.dis.skip(entryPosition);
        }

        public byte getVersion() {
            return this.version;
        }

        public String getRegionName() {
            return this.region;
        }

        public ExportedRegistry getPdxTypes() {
            return this.pdx;
        }

        public SnapshotPacket.SnapshotRecord readSnapshotRecord() throws IOException, ClassNotFoundException {
            byte[] key2 = DataSerializer.readByteArray(this.dis);
            if (key2 == null) {
                return null;
            }
            byte[] value2 = DataSerializer.readByteArray(this.dis);
            return new SnapshotPacket.SnapshotRecord(key2, value2);
        }

        public void close() throws IOException {
            this.dis.close();
        }

        private TypeRegistry getRegistry() {
            GemFireCacheImpl gfc = GemFireCacheImpl.getInstance();
            if (gfc != null) {
                return gfc.getPdxRegistry();
            }
            return null;
        }

        private void checkPdxTypeCompatibility() {
            TypeRegistry tr = this.getRegistry();
            if (tr == null) {
                return;
            }
            for (Map.Entry<Integer, PdxType> entry : this.pdx.types().entrySet()) {
                tr.addImportedType(entry.getKey(), entry.getValue());
            }
        }

        private void checkPdxEnumCompatibility() {
            TypeRegistry tr = this.getRegistry();
            if (tr == null) {
                return;
            }
            for (Map.Entry<Integer, EnumInfo> entry : this.pdx.enums().entrySet()) {
                tr.addImportedEnum(entry.getKey(), entry.getValue());
            }
        }
    }

    static class GFSnapshotExporter {
        private final FileChannel fc;
        private final DataOutputStream dos;

        public GFSnapshotExporter(File out, String region) throws IOException {
            FileOutputStream fos = new FileOutputStream(out);
            this.fc = fos.getChannel();
            this.dos = new DataOutputStream(new BufferedOutputStream(fos));
            this.dos.writeByte(2);
            this.dos.write(SNAP_FMT);
            this.dos.writeLong(-1L);
            this.dos.writeUTF(region);
        }

        public void writeSnapshotEntry(SnapshotPacket.SnapshotRecord entry) throws IOException {
            InternalDataSerializer.invokeToData(entry, this.dos);
        }

        public void close() throws IOException {
            DataSerializer.writeByteArray(null, this.dos);
            this.dos.flush();
            long registryPosition = this.fc.position();
            try {
                GemFireCacheImpl cache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                new ExportedRegistry(cache.getPdxRegistry()).toData(this.dos);
            }
            catch (CacheClosedException e) {
                new ExportedRegistry().toData(this.dos);
            }
            this.dos.flush();
            this.fc.position(4L);
            this.dos.writeLong(registryPosition);
            this.dos.close();
        }
    }

    public static interface SnapshotWriter {
        public void snapshotEntry(SnapshotPacket.SnapshotRecord var1) throws IOException;

        public void snapshotComplete() throws IOException;
    }
}

