/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.snapshot;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.cache.execute.ResultSender;
import com.gemstone.gemfire.cache.snapshot.SnapshotOptions;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.snapshot.LocalExporter;
import com.gemstone.gemfire.internal.cache.snapshot.RegionSnapshotServiceImpl;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotPacket;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ClientExporter<K, V>
implements RegionSnapshotServiceImpl.Exporter<K, V> {
    private final Pool pool;

    public ClientExporter(Pool p) {
        this.pool = p;
    }

    @Override
    public long export(Region<K, V> region, RegionSnapshotServiceImpl.ExportSink sink, SnapshotOptions<K, V> options) throws IOException {
        try {
            ClientArgs<K, V> args = new ClientArgs<K, V>(region.getFullPath(), this.pool.getPRSingleHopEnabled(), options);
            ClientExportCollector results = new ClientExportCollector(sink);
            Execution exec = this.pool.getPRSingleHopEnabled() ? FunctionService.onRegion(region) : FunctionService.onServer(this.pool);
            ResultCollector<?, ?> rc = exec.withArgs(args).withCollector(results).execute(new ProxyExportFunction());
            return (Long)rc.getResult();
        }
        catch (FunctionException e) {
            throw new IOException(e);
        }
    }

    private static class ClientExportCollector
    implements ResultCollector<Object, Long> {
        private final AtomicLong count;
        private final RegionSnapshotServiceImpl.ExportSink sink;
        private volatile Exception error;

        public ClientExportCollector(RegionSnapshotServiceImpl.ExportSink sink) {
            this.sink = sink;
            this.count = new AtomicLong(0L);
        }

        @Override
        public Long getResult() throws FunctionException {
            if (this.error != null) {
                throw new FunctionException(this.error);
            }
            return this.count.get();
        }

        @Override
        public Long getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            return this.getResult();
        }

        @Override
        public void addResult(DistributedMember memberID, Object result) {
            if (result instanceof Long) {
                this.count.addAndGet((Long)result);
            } else if (result instanceof Exception) {
                this.error = (Exception)result;
            } else {
                try {
                    this.sink.write((SnapshotPacket.SnapshotRecord[])result);
                }
                catch (IOException e) {
                    this.error = e;
                }
            }
        }

        @Override
        public void endResults() {
        }

        @Override
        public void clearResults() {
        }
    }

    private static class ProxyExportFunction<K, V>
    implements Function {
        private static final long serialVersionUID = 1L;

        private ProxyExportFunction() {
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public void execute(FunctionContext context) {
            ClientArgs args = (ClientArgs)context.getArguments();
            ResultSender<SnapshotPacket.SnapshotRecord[]> rs = context.getResultSender();
            RegionSnapshotServiceImpl.ResultSenderSink sink = new RegionSnapshotServiceImpl.ResultSenderSink(rs);
            Region region = GemFireCacheImpl.getExisting("Exporting snapshot").getRegion(args.getRegion());
            RegionSnapshotServiceImpl.Exporter exp = args.isPRSingleHop() ? new LocalExporter() : RegionSnapshotServiceImpl.createExporter(region, args.options);
            try {
                long count = exp.export(region, sink, args.getOptions());
                rs.lastResult((SnapshotPacket.SnapshotRecord[])count);
            }
            catch (IOException e) {
                rs.sendException(e);
            }
        }

        @Override
        public String getId() {
            return "com.gemstone.gemfire.cache.snapshot.ClientExport";
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }

    private static class ClientArgs<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String region;
        private final boolean prSingleHop;
        private final SnapshotOptions<K, V> options;

        public ClientArgs(String region, boolean prSingleHop, SnapshotOptions<K, V> options) {
            this.region = region;
            this.prSingleHop = prSingleHop;
            this.options = options;
        }

        public String getRegion() {
            return this.region;
        }

        public boolean isPRSingleHop() {
            return this.prSingleHop;
        }

        public SnapshotOptions<K, V> getOptions() {
            return this.options;
        }
    }
}

