/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.ByteComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.Compactor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;

public interface SortedOplogFactory {
    public SortedOplogConfiguration getConfiguration();

    public SortedOplog createSortedOplog(File var1) throws IOException;

    public static class SortedOplogConfiguration {
        public static Compactor.MetadataCompactor DEFAULT_METADATA_COMPACTOR = new Compactor.MetadataCompactor(){

            @Override
            public byte[] compact(byte[] metadata1, byte[] metadata2) {
                return metadata1;
            }
        };
        private final String name;
        private final SortedOplogStatistics stats;
        private boolean bloom;
        private int blockSize;
        private int bytesPerChecksum;
        private Checksum checksum;
        private Compression compression;
        private KeyEncoding keyEncoding;
        private SortedReader.SerializedComparator comparator;
        private EnumMap<SortedReader.Metadata, Compactor.MetadataCompactor> metaCompactors;

        public SortedOplogConfiguration(String name) {
            this(name, new SortedOplogStatistics("GridDBRegionStatistics", name));
        }

        public SortedOplogConfiguration(String name, SortedOplogStatistics stats) {
            this.name = name;
            this.stats = stats;
            this.bloom = true;
            this.blockSize = 65536;
            this.bytesPerChecksum = 16384;
            this.checksum = Checksum.NONE;
            this.compression = Compression.NONE;
            this.keyEncoding = KeyEncoding.NONE;
            this.comparator = new ByteComparator();
        }

        public SortedOplogConfiguration setBloomFilterEnabled(boolean enabled) {
            this.bloom = enabled;
            return this;
        }

        public SortedOplogConfiguration setBlockSize(int size2) {
            this.blockSize = size2;
            return this;
        }

        public SortedOplogConfiguration setBytesPerChecksum(int bytes) {
            this.bytesPerChecksum = bytes;
            return this;
        }

        public SortedOplogConfiguration setChecksum(Checksum type) {
            this.checksum = type;
            return this;
        }

        public SortedOplogConfiguration setCompression(Compression type) {
            this.compression = type;
            return this;
        }

        public SortedOplogConfiguration setKeyEncoding(KeyEncoding type) {
            this.keyEncoding = type;
            return this;
        }

        public SortedOplogConfiguration setComparator(SortedReader.SerializedComparator comp) {
            this.comparator = comp;
            return this;
        }

        public SortedOplogConfiguration addMetadataCompactor(SortedReader.Metadata name, Compactor.MetadataCompactor compactor) {
            this.metaCompactors.put(name, compactor);
            return this;
        }

        public String getName() {
            return this.name;
        }

        public SortedOplogStatistics getStatistics() {
            return this.stats;
        }

        public boolean isBloomFilterEnabled() {
            return this.bloom;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public int getBytesPerChecksum() {
            return this.bytesPerChecksum;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public Compression getCompression() {
            return this.compression;
        }

        public KeyEncoding getKeyEncoding() {
            return this.keyEncoding;
        }

        public SortedReader.SerializedComparator getComparator() {
            return this.comparator;
        }

        public Compactor.MetadataCompactor getMetadataCompactor(SortedReader.Metadata name) {
            Compactor.MetadataCompactor mc = this.metaCompactors.get((Object)name);
            if (mc != null) {
                return mc;
            }
            return DEFAULT_METADATA_COMPACTOR;
        }

        public static enum KeyEncoding {
            NONE;

        }

        public static enum Compression {
            NONE;

        }

        public static enum Checksum {
            NONE,
            CRC32;

        }
    }
}

