/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.AbstractKeyValueIterator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.AbstractSortedReader;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogFactory;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.logging.log4j.Logger;

public class SortedBuffer<T>
extends AbstractSortedReader {
    private static final Logger logger = LogService.getLogger();
    private final T tag;
    private final NavigableMap<byte[], byte[]> buffer;
    private final BufferStats stats;
    private final EnumMap<SortedReader.Metadata, byte[]> metadata;
    private Runnable flushAction;
    private final String logPrefix;

    public SortedBuffer(SortedOplogFactory.SortedOplogConfiguration config, T tag) {
        assert (config != null);
        assert (tag != null);
        this.tag = tag;
        this.buffer = new ConcurrentSkipListMap<byte[], byte[]>(config.getComparator());
        this.stats = new BufferStats();
        this.metadata = new EnumMap(SortedReader.Metadata.class);
        this.logPrefix = "<" + config.getName() + "#" + tag + "> ";
    }

    public T getTag() {
        return this.tag;
    }

    public String toString() {
        return logger.getName() + this.logPrefix;
    }

    public void put(byte[] key2, byte[] value2) {
        if (this.buffer.put(key2, value2) == null) {
            this.stats.add(key2.length, value2.length);
        }
    }

    public Iterable<Map.Entry<byte[], byte[]>> entries() {
        return this.buffer.entrySet();
    }

    public int count() {
        return this.buffer.size();
    }

    public long dataSize() {
        return this.stats.totalSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Clearing buffer", this.logPrefix);
        }
        this.buffer.clear();
        this.stats.clear();
        this.metadata.clear();
        SortedBuffer sortedBuffer = this;
        synchronized (sortedBuffer) {
            this.flushAction = null;
        }
    }

    public synchronized boolean isDeferred() {
        return this.flushAction != null;
    }

    public synchronized void defer(Runnable action) {
        assert (this.flushAction == null);
        if (logger.isDebugEnabled()) {
            logger.debug("{}Deferring flush completion", this.logPrefix);
        }
        this.flushAction = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void complete() {
        assert (this.flushAction != null);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Completing deferred flush operation", this.logPrefix);
            }
            this.flushAction.run();
        }
        finally {
            this.flushAction = null;
        }
    }

    public synchronized EnumMap<SortedReader.Metadata, byte[]> getMetadata() {
        return this.metadata;
    }

    public synchronized byte[] getMetadata(SortedReader.Metadata name) {
        return this.metadata.get((Object)name);
    }

    public synchronized void setMetadata(EnumMap<SortedReader.Metadata, byte[]> metadata) {
        if (metadata != null) {
            this.metadata.putAll(metadata);
        }
    }

    @Override
    public boolean mightContain(byte[] key2) {
        return true;
    }

    @Override
    public ByteBuffer read(byte[] key2) throws IOException {
        byte[] val = (byte[])this.buffer.get(key2);
        if (val != null) {
            return ByteBuffer.wrap(val);
        }
        return null;
    }

    @Override
    public SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive, boolean ascending, SortedReader.MetadataFilter filter) {
        if (filter == null || filter.accept(this.metadata.get((Object)filter.getName()))) {
            NavigableMap<byte[], byte[]> subset;
            NavigableMap<byte[], byte[]> navigableMap = subset = ascending ? this.buffer : this.buffer.descendingMap();
            if (from != null || to != null) {
                subset = from == null ? subset.headMap(to, toInclusive) : (to == null ? subset.tailMap(from, fromInclusive) : subset.subMap(from, fromInclusive, to, toInclusive));
            }
            return new BufferIterator(subset.entrySet().iterator());
        }
        return new BufferIterator(Collections.emptyMap().entrySet().iterator());
    }

    @Override
    public SortedReader.SerializedComparator getComparator() {
        return (SortedReader.SerializedComparator)this.buffer.comparator();
    }

    @Override
    public SortedReader.SortedStatistics getStatistics() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Closing buffer", this.logPrefix);
        }
        SortedBuffer sortedBuffer = this;
        synchronized (sortedBuffer) {
            this.flushAction = null;
        }
    }

    private class BufferStats
    implements SortedReader.SortedStatistics {
        private long totalSize;
        private long keys;
        private double avgKeySize;
        private double avgValueSize;

        private BufferStats() {
        }

        private synchronized void clear() {
            this.totalSize = 0L;
            this.keys = 0L;
            this.avgKeySize = 0.0;
            this.avgValueSize = 0.0;
        }

        private synchronized void add(int keyLength, int valueLength) {
            this.totalSize += (long)(keyLength + valueLength);
            this.avgKeySize = ((double)keyLength + (double)this.keys * this.avgKeySize) / (double)(this.keys + 1L);
            this.avgValueSize = ((double)keyLength + (double)this.keys * this.avgValueSize) / (double)(this.keys + 1L);
            ++this.keys;
        }

        @Override
        public synchronized long keyCount() {
            return this.keys;
        }

        @Override
        public byte[] firstKey() {
            return (byte[])SortedBuffer.this.buffer.firstKey();
        }

        @Override
        public byte[] lastKey() {
            return (byte[])SortedBuffer.this.buffer.lastKey();
        }

        @Override
        public synchronized double avgKeySize() {
            return this.avgKeySize;
        }

        @Override
        public synchronized double avgValueSize() {
            return this.avgValueSize;
        }

        @Override
        public void close() {
        }

        public synchronized long totalSize() {
            return this.totalSize;
        }
    }

    public static class BufferIterator
    extends AbstractKeyValueIterator<ByteBuffer, ByteBuffer>
    implements SortedReader.SortedIterator<ByteBuffer> {
        private final Iterator<Map.Entry<byte[], byte[]>> entries;
        private Map.Entry<byte[], byte[]> current;

        public BufferIterator(Iterator<Map.Entry<byte[], byte[]>> iterator) {
            this.entries = iterator;
        }

        @Override
        public ByteBuffer key() {
            return ByteBuffer.wrap(this.current.getKey());
        }

        @Override
        public ByteBuffer value() {
            return ByteBuffer.wrap(this.current.getValue());
        }

        @Override
        public void close() {
        }

        @Override
        protected boolean step() {
            this.current = this.entries.hasNext() ? this.entries.next() : null;
            return this.current != null;
        }
    }
}

