/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.Compactor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class NonCompactor
implements Compactor {
    private final Compactor.Fileset<Integer> fileset;
    private final Deque<TrackedReference<SortedOplog.SortedOplogReader>> readers;

    public static Compactor.Fileset<Integer> createFileset(final String name, final File dir) {
        return new Compactor.Fileset<Integer>(){
            private final AtomicLong file = new AtomicLong(0L);

            @Override
            public SortedMap<Integer, ? extends Iterable<File>> recover() {
                return new TreeMap();
            }

            @Override
            public File getNextFilename() {
                return new File(dir, name + "-" + System.currentTimeMillis() + "-" + this.file.getAndIncrement() + ".soplog");
            }
        };
    }

    public NonCompactor(String name, File dir) {
        this.fileset = NonCompactor.createFileset(name, dir);
        this.readers = new ArrayDeque<TrackedReference<SortedOplog.SortedOplogReader>>();
    }

    @Override
    public boolean compact() throws IOException {
        return true;
    }

    @Override
    public void compact(boolean force, Compactor.CompactionHandler cd2) {
    }

    @Override
    public synchronized Collection<TrackedReference<SortedOplog.SortedOplogReader>> getActiveReaders(byte[] start, byte[] end) {
        for (TrackedReference<SortedOplog.SortedOplogReader> tr : this.readers) {
            tr.increment();
        }
        return new ArrayList<TrackedReference<SortedOplog.SortedOplogReader>>(this.readers);
    }

    @Override
    public void add(SortedOplog soplog) throws IOException {
        this.readers.addFirst(new TrackedReference<SortedOplog.SortedOplogReader>(soplog.createReader()));
    }

    @Override
    public synchronized void clear() throws IOException {
        for (TrackedReference<SortedOplog.SortedOplogReader> tr : this.readers) {
            tr.get().close();
            this.readers.remove(tr);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.clear();
    }

    public Compactor.CompactionTracker<Integer> getTracker() {
        return null;
    }

    public Compactor.Fileset<Integer> getFileset() {
        return this.fileset;
    }
}

