/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.Compactor;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class LevelTracker
implements Compactor.Fileset<Integer>,
Compactor.CompactionTracker<Integer>,
Closeable {
    private final String name;
    private final File manifest;
    private final SortedMap<Integer, Set<File>> levels;
    private final AtomicLong file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelTracker(String name, File manifest) throws IOException {
        this.name = name;
        this.manifest = manifest;
        this.file = new AtomicLong(0L);
        this.levels = new TreeMap<Integer, Set<File>>();
        if (!manifest.exists()) {
            return;
        }
        try (LineNumberReader rdr = new LineNumberReader(new FileReader(manifest));){
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] parts = line.split(",");
                int level = Integer.parseInt(parts[0]);
                File f = new File(parts[1]);
                this.add(f, level);
            }
        }
    }

    @Override
    public SortedMap<Integer, ? extends Iterable<File>> recover() {
        return this.levels;
    }

    @Override
    public File getNextFilename() {
        return new File(this.manifest.getParentFile(), this.name + "-" + System.currentTimeMillis() + "-" + this.file.getAndIncrement() + ".soplog");
    }

    @Override
    public void fileAdded(File f, Integer attach) {
        this.add(f, attach);
    }

    @Override
    public void fileRemoved(File f, Integer attach) {
        ((Set)this.levels.get(attach)).remove(f);
    }

    @Override
    public void fileDeleted(File f) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        FileWriter wtr = new FileWriter(this.manifest);
        try {
            for (Map.Entry<Integer, Set<File>> entry : this.levels.entrySet()) {
                for (File f : entry.getValue()) {
                    wtr.write(entry.getKey() + "," + f + "\n");
                }
            }
        }
        finally {
            ((Writer)wtr).flush();
            ((Writer)wtr).close();
        }
    }

    private void add(File f, int level) {
        HashSet<File> files = (HashSet<File>)this.levels.get(level);
        if (files == null) {
            files = new HashSet<File>();
            this.levels.put(level, files);
        }
        files.add(f);
    }
}

