/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.ByteComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.CompositeSerializedComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.DelegatingSerializedComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.LexicographicalComparator;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SoplogToken;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.util.Bytes;
import java.nio.ByteBuffer;

public class IndexSerializedComparator
implements CompositeSerializedComparator,
DelegatingSerializedComparator {
    private volatile SortedReader.SerializedComparator primary = new LexicographicalComparator();
    private volatile SortedReader.SerializedComparator secondary = new ByteComparator();

    @Override
    public void setComparators(SortedReader.SerializedComparator[] comparators) {
        assert (comparators.length == 2);
        this.primary = comparators[0];
        this.secondary = comparators[1];
    }

    @Override
    public SortedReader.SerializedComparator[] getComparators() {
        return new SortedReader.SerializedComparator[]{this.primary, this.secondary};
    }

    @Override
    public int compare(byte[] o1, byte[] o2) {
        return this.compare(o1, 0, o1.length, o2, 0, o2.length);
    }

    @Override
    public int compare(byte[] b1, int o1, int l1, byte[] b2, int o2, int l2) {
        int diff;
        int off2;
        int klen1 = Bytes.getVarInt(b1, o1);
        int klen2 = Bytes.getVarInt(b2, o2);
        int off1 = o1 + Bytes.sizeofVarInt(klen1);
        if (!SoplogToken.isWildcard(b1, off1, b2, off2 = o2 + Bytes.sizeofVarInt(klen2)) && (diff = this.primary.compare(b1, off1, klen1, b2, off2, klen2)) != 0) {
            return diff;
        }
        if (!SoplogToken.isWildcard(b1, off1 += klen1, b2, off2 += klen2)) {
            return this.secondary.compare(b1, off1, l1 -= off1 - o1, b2, off2, l2 -= off2 - o2);
        }
        return 0;
    }

    @Override
    public ByteBuffer getKey(ByteBuffer key2, int ordinal) {
        assert (ordinal < 2);
        int klen = Bytes.getVarInt(key2);
        ByteBuffer subkey = ordinal == 0 ? (ByteBuffer)key2.slice().limit(klen) : ((ByteBuffer)key2.position(key2.position() + klen)).slice();
        key2.rewind();
        return subkey;
    }

    @Override
    public byte[] createCompositeKey(byte[] key1, byte[] key2) {
        int vlen = Bytes.sizeofVarInt(key1.length);
        byte[] buf = new byte[vlen + key1.length + key2.length];
        Bytes.putVarInt(key1.length, buf, 0);
        System.arraycopy(key1, 0, buf, vlen, key1.length);
        System.arraycopy(key2, 0, buf, vlen + key1.length, key2.length);
        return buf;
    }

    @Override
    public byte[] createCompositeKey(byte[] ... keys) {
        assert (keys.length == 2);
        return this.createCompositeKey(keys[0], keys[1]);
    }
}

