/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedMap;

public interface Compactor {
    public boolean compact() throws IOException;

    public void compact(boolean var1, CompactionHandler var2);

    public Collection<TrackedReference<SortedOplog.SortedOplogReader>> getActiveReaders(byte[] var1, byte[] var2);

    public void add(SortedOplog var1) throws IOException;

    public CompactionTracker<?> getTracker();

    public Fileset<?> getFileset();

    public void clear() throws IOException;

    public void close() throws IOException;

    public static interface CompactionTracker<T extends Comparable<T>> {
        public void fileAdded(File var1, T var2);

        public void fileRemoved(File var1, T var2);

        public void fileDeleted(File var1);
    }

    public static interface Fileset<T extends Comparable<T>> {
        public SortedMap<T, ? extends Iterable<File>> recover();

        public File getNextFilename();
    }

    public static interface CompactionHandler {
        public void complete(boolean var1);

        public void failed(Throwable var1);
    }

    public static interface MetadataCompactor {
        public byte[] compact(byte[] var1, byte[] var2);
    }
}

