/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractSortedReader
implements SortedReader<ByteBuffer> {
    @Override
    public final SortedReader.SortedIterator<ByteBuffer> scan() throws IOException {
        return this.scan(null, true, null, true);
    }

    @Override
    public final SortedReader.SortedIterator<ByteBuffer> head(byte[] to, boolean inclusive) throws IOException {
        return this.scan(null, true, to, inclusive);
    }

    @Override
    public final SortedReader.SortedIterator<ByteBuffer> tail(byte[] from, boolean inclusive) throws IOException {
        return this.scan(from, inclusive, null, true);
    }

    @Override
    public final SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, byte[] to) throws IOException {
        return this.scan(from, true, to, false);
    }

    @Override
    public final SortedReader.SortedIterator<ByteBuffer> scan(byte[] equalTo) throws IOException {
        return this.scan(equalTo, true, equalTo, true);
    }

    @Override
    public SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
        return this.scan(from, fromInclusive, to, toInclusive, true, null);
    }

    @Override
    public final SortedReader<ByteBuffer> withAscending(boolean ascending) {
        if (this instanceof DelegateSortedReader) {
            DelegateSortedReader tmp = (DelegateSortedReader)this;
            return new DelegateSortedReader(tmp.delegate, ascending, tmp.filter);
        }
        return new DelegateSortedReader(this, ascending, null);
    }

    @Override
    public final SortedReader<ByteBuffer> withFilter(SortedReader.MetadataFilter filter) {
        if (this instanceof DelegateSortedReader) {
            DelegateSortedReader tmp = (DelegateSortedReader)this;
            return new DelegateSortedReader(tmp.delegate, tmp.ascending, filter);
        }
        return new DelegateSortedReader(this, true, filter);
    }

    protected class DelegateSortedReader
    extends AbstractSortedReader {
        private final AbstractSortedReader delegate;
        private final boolean ascending;
        private final SortedReader.MetadataFilter filter;

        public DelegateSortedReader(AbstractSortedReader reader, boolean ascending, SortedReader.MetadataFilter filter) {
            this.delegate = reader;
            this.ascending = ascending;
            this.filter = filter;
        }

        @Override
        public boolean mightContain(byte[] key2) throws IOException {
            return this.delegate.mightContain(key2);
        }

        @Override
        public ByteBuffer read(byte[] key2) throws IOException {
            return (ByteBuffer)this.delegate.read(key2);
        }

        @Override
        public SortedReader.SerializedComparator getComparator() {
            return this.delegate.getComparator();
        }

        @Override
        public SortedReader.SortedStatistics getStatistics() throws IOException {
            return this.delegate.getStatistics();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive) throws IOException {
            return this.scan(from, fromInclusive, to, toInclusive, this.ascending, this.filter);
        }

        @Override
        public SortedReader.SortedIterator<ByteBuffer> scan(byte[] from, boolean fromInclusive, byte[] to, boolean toInclusive, boolean ascending, SortedReader.MetadataFilter filter) throws IOException {
            return this.delegate.scan(from, fromInclusive, to, toInclusive, ascending, filter);
        }
    }
}

