/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.soplog;

import com.gemstone.gemfire.internal.cache.persistence.soplog.Compactor;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SoplogToken;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplog;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogFactory;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogSetImpl;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedReader;
import com.gemstone.gemfire.internal.cache.persistence.soplog.TrackedReference;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.util.AbortableTaskService;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public abstract class AbstractCompactor<T extends Comparable<T>>
implements Compactor {
    protected static final Logger logger = LogService.getLogger();
    protected final SortedOplogFactory factory;
    protected final Compactor.Fileset<T> fileset;
    protected final Compactor.CompactionTracker<T> tracker;
    protected final AbortableTaskService compactor;
    private final Queue<TrackedReference<SortedOplog.SortedOplogReader>> inactive;
    protected final List<Level> levels;
    private final ReadWriteLock levelLock;
    volatile boolean testAbortDuringCompaction;
    volatile CountDownLatch testDelayDuringCompaction;
    protected final String logPrefix;

    public AbstractCompactor(SortedOplogFactory factory, Compactor.Fileset<T> fileset, Compactor.CompactionTracker<T> tracker, Executor exec) {
        assert (factory != null);
        assert (fileset != null);
        assert (tracker != null);
        assert (exec != null);
        this.factory = factory;
        this.fileset = fileset;
        this.tracker = tracker;
        this.compactor = new AbortableTaskService(exec);
        this.inactive = new ConcurrentLinkedQueue<TrackedReference<SortedOplog.SortedOplogReader>>();
        this.levelLock = new ReentrantReadWriteLock();
        this.levels = new ArrayList<Level>();
        this.logPrefix = "<" + factory.getConfiguration().getName() + "> ";
    }

    @Override
    public final void add(SortedOplog soplog) throws IOException {
        this.levels.get(0).add(soplog);
    }

    @Override
    public final boolean compact() throws IOException {
        final CountDownLatch done = new CountDownLatch(1);
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.compact(true, new Compactor.CompactionHandler(){

            @Override
            public void complete(boolean compacted) {
                result.set(compacted);
                done.countDown();
            }

            @Override
            public void failed(Throwable ex) {
                result.set(ex);
                done.countDown();
            }
        });
        try {
            done.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException();
        }
        Object val = result.get();
        if (val instanceof Throwable) {
            throw new IOException(val);
        }
        assert (val != null);
        return val;
    }

    @Override
    public final void compact(final boolean force, final Compactor.CompactionHandler ch) {
        AbortableTaskService.AbortableTask task = new AbortableTaskService.AbortableTask(){

            @Override
            public void runOrAbort(AtomicBoolean aborted) {
                block11: {
                    boolean isDebugEnabled = logger.isDebugEnabled();
                    if (isDebugEnabled) {
                        logger.debug("{}Beginning compaction", AbstractCompactor.this.logPrefix);
                    }
                    try {
                        boolean compacted = false;
                        for (Level level : AbstractCompactor.this.levels) {
                            if (aborted.get()) {
                                if (!isDebugEnabled) break;
                                logger.debug("{}Aborting compaction", AbstractCompactor.this.logPrefix);
                                break;
                            }
                            AbstractCompactor.this.checkTestDelay();
                            if (!force && !level.needsCompaction()) continue;
                            if (isDebugEnabled) {
                                logger.debug("{}Compacting level {}", AbstractCompactor.this.logPrefix, level);
                            }
                            long start = AbstractCompactor.this.factory.getConfiguration().getStatistics().getMinorCompaction().begin();
                            try {
                                compacted |= level.compact(aborted);
                                AbstractCompactor.this.factory.getConfiguration().getStatistics().getMinorCompaction().end(start);
                            }
                            catch (IOException e) {
                                AbstractCompactor.this.factory.getConfiguration().getStatistics().getMinorCompaction().error(start);
                            }
                        }
                        AbstractCompactor.this.cleanupInactive();
                        if (ch != null) {
                            if (isDebugEnabled) {
                                logger.debug("{}Completed compaction", AbstractCompactor.this.logPrefix);
                            }
                            ch.complete(compacted);
                        }
                    }
                    catch (Exception e) {
                        if (isDebugEnabled) {
                            logger.debug("{}Encountered an error during compaction", AbstractCompactor.this.logPrefix, e);
                        }
                        if (ch == null) break block11;
                        ch.failed(e);
                    }
                }
            }

            @Override
            public void abortBeforeRun() {
                if (ch != null) {
                    ch.complete(false);
                }
            }
        };
        this.compactor.execute(task);
    }

    @Override
    public final Compactor.CompactionTracker<?> getTracker() {
        return this.tracker;
    }

    @Override
    public final Compactor.Fileset<?> getFileset() {
        return this.fileset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<TrackedReference<SortedOplog.SortedOplogReader>> getActiveReaders(byte[] start, byte[] end) {
        this.levelLock.readLock().lock();
        try {
            ArrayList<TrackedReference<SortedOplog.SortedOplogReader>> soplogs = new ArrayList<TrackedReference<SortedOplog.SortedOplogReader>>();
            for (Level level : this.levels) {
                soplogs.addAll(level.getSnapshot(start, end));
            }
            ArrayList<TrackedReference<SortedOplog.SortedOplogReader>> arrayList = soplogs;
            return arrayList;
        }
        finally {
            this.levelLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("{}Clearing compactor", this.logPrefix);
        }
        this.compactor.abortAll();
        this.releaseTestDelay();
        this.compactor.waitForCompletion();
        this.levelLock.writeLock().lock();
        try {
            for (Level l : this.levels) {
                l.clear();
            }
        }
        finally {
            this.levelLock.writeLock().unlock();
        }
        this.cleanupInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        TrackedReference<SortedOplog.SortedOplogReader> tr;
        if (logger.isDebugEnabled()) {
            logger.debug("{}Closing compactor", this.logPrefix);
        }
        this.compactor.abortAll();
        this.releaseTestDelay();
        this.compactor.waitForCompletion();
        this.levelLock.writeLock().lock();
        try {
            for (Level l : this.levels) {
                l.close();
            }
        }
        finally {
            this.levelLock.writeLock().unlock();
        }
        while ((tr = this.inactive.poll()) != null) {
            this.deleteInactive(tr);
        }
        this.inactive.clear();
    }

    protected SortedOplog merge(Collection<TrackedReference<SortedOplog.SortedOplogReader>> readers, boolean collect, AtomicBoolean aborted) throws IOException {
        SortedReader.SerializedComparator sc = null;
        ArrayList<SortedReader.SortedIterator<ByteBuffer>> iters = new ArrayList<SortedReader.SortedIterator<ByteBuffer>>();
        for (TrackedReference<SortedOplog.SortedOplogReader> tr : readers) {
            iters.add(tr.get().scan());
            sc = tr.get().getComparator();
        }
        try (SortedOplogSetImpl.MergedIterator scan = new SortedOplogSetImpl.MergedIterator(sc, readers, iters);){
            if (!scan.hasNext()) {
                TrackedReference<SortedOplog.SortedOplogReader> tr;
                this.checkAbort(aborted);
                if (logger.isDebugEnabled()) {
                    logger.debug("{}No entries left after compaction with readers {} ", this.logPrefix, readers);
                }
                tr = null;
                return tr;
            }
            File f = this.fileset.getNextFilename();
            if (logger.isDebugEnabled()) {
                logger.debug("{}Compacting soplogs {} into {}", this.logPrefix, readers, f);
            }
            if (this.testAbortDuringCompaction) {
                aborted.set(true);
            }
            SortedOplog soplog = this.factory.createSortedOplog(f);
            SortedOplog.SortedOplogWriter wtr = soplog.createWriter();
            try {
                while (scan.hasNext()) {
                    this.checkAbort(aborted);
                    scan.next();
                    if (collect && this.isDeleted((ByteBuffer)scan.value())) continue;
                    wtr.append((ByteBuffer)scan.key(), (ByteBuffer)scan.value());
                }
                EnumMap<SortedReader.Metadata, byte[]> metadata = this.mergeMetadata(readers);
                wtr.close(metadata);
                SortedOplog sortedOplog = soplog;
                return sortedOplog;
            }
            catch (IOException e) {
                wtr.closeAndDelete();
                throw e;
            }
        }
    }

    protected EnumMap<SortedReader.Metadata, byte[]> mergeMetadata(Collection<TrackedReference<SortedOplog.SortedOplogReader>> readers) throws IOException {
        EnumMap<SortedReader.Metadata, byte[]> metadata = new EnumMap<SortedReader.Metadata, byte[]>(SortedReader.Metadata.class);
        for (SortedReader.Metadata meta : SortedReader.Metadata.values()) {
            byte[] val = null;
            for (TrackedReference<SortedOplog.SortedOplogReader> tr : readers) {
                byte[] tmp = tr.get().getMetadata(meta);
                if (val == null) {
                    val = tmp;
                    continue;
                }
                if (tmp == null) continue;
                val = this.factory.getConfiguration().getMetadataCompactor(meta).compact(val, tmp);
            }
            if (val == null) continue;
            metadata.put(meta, val);
        }
        return metadata;
    }

    protected void releaseTestDelay() {
        if (this.testDelayDuringCompaction != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Releasing testDelayDuringCompaction", this.logPrefix);
            }
            this.testDelayDuringCompaction.countDown();
        }
    }

    protected void checkTestDelay() {
        if (this.testDelayDuringCompaction != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}Waiting for testDelayDuringCompaction", this.logPrefix);
                }
                this.testDelayDuringCompaction.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected int countInactiveReaders() {
        return this.inactive.size();
    }

    protected Level getLevel(int level) {
        return this.levels.get(level);
    }

    protected void cleanupInactive() throws IOException {
        for (TrackedReference trackedReference : this.inactive) {
            if (trackedReference.inUse() || !this.inactive.remove(trackedReference)) continue;
            this.deleteInactive(trackedReference);
        }
    }

    protected void markAsInactive(Iterable<TrackedReference<SortedOplog.SortedOplogReader>> snapshot, T attach) throws IOException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        for (TrackedReference<SortedOplog.SortedOplogReader> tr : snapshot) {
            if (isDebugEnabled) {
                logger.debug("{}Marking {} as inactive", this.logPrefix, tr);
            }
            this.inactive.add(tr);
            this.tracker.fileRemoved(tr.get().getFile(), attach);
            this.factory.getConfiguration().getStatistics().incActiveFiles(-1);
            this.factory.getConfiguration().getStatistics().incInactiveFiles(1);
        }
    }

    private boolean isDeleted(ByteBuffer value2) {
        byte valType = value2.get(value2.position());
        return SoplogToken.isTombstone(valType) || SoplogToken.isRemovedPhase2(valType);
    }

    private void checkAbort(AtomicBoolean aborted) throws InterruptedIOException {
        if (aborted.get()) {
            throw new InterruptedIOException();
        }
    }

    private void deleteInactive(TrackedReference<SortedOplog.SortedOplogReader> tr) throws IOException {
        tr.get().close();
        if (tr.get().getFile().delete()) {
            if (logger.isDebugEnabled()) {
                logger.debug("{}Deleted inactive soplog {}", this.logPrefix, tr.get().getFile());
            }
            this.tracker.fileDeleted(tr.get().getFile());
            this.factory.getConfiguration().getStatistics().incInactiveFiles(-1);
        }
    }

    protected static abstract class Level {
        protected final int level;

        public Level(int level) {
            this.level = level;
        }

        public String toString() {
            return String.valueOf(this.level);
        }

        protected abstract boolean needsCompaction();

        protected List<TrackedReference<SortedOplog.SortedOplogReader>> getSnapshot() {
            return this.getSnapshot(null, null);
        }

        protected abstract List<TrackedReference<SortedOplog.SortedOplogReader>> getSnapshot(byte[] var1, byte[] var2);

        protected abstract void clear() throws IOException;

        protected abstract void close() throws IOException;

        protected abstract void add(SortedOplog var1) throws IOException;

        protected abstract boolean compact(AtomicBoolean var1) throws IOException;
    }
}

