/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.query.mock;

import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.cache.persistence.query.IdentityExtractor;
import com.gemstone.gemfire.internal.cache.persistence.query.ResultSet;
import com.gemstone.gemfire.internal.cache.persistence.query.SortKeyExtractor;
import com.gemstone.gemfire.internal.cache.persistence.query.mock.SortedResultMapImpl;

public class SortedResultSetImpl
implements ResultSet {
    private final SortedResultMapImpl map;
    private SortKeyExtractor extractor;

    public SortedResultSetImpl(SortKeyExtractor extractor, boolean reverse) {
        this.extractor = extractor == null ? new IdentityExtractor() : extractor;
        this.map = new SortedResultMapImpl(reverse);
    }

    @Override
    public void add(Object e) {
        this.map.put(this.extractor.getSortKey(e), e);
    }

    @Override
    public CloseableIterator<CachedDeserializable> iterator() {
        return this.map.valueIterator();
    }

    @Override
    public void close() {
        this.map.close();
    }
}

