/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence.query.mock;

import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import java.util.Comparator;

public class ByteComparator
implements Comparator<Object> {
    public static final byte[] MIN_BYTES = new byte[0];
    public static final byte[] MAX_BYTES = new byte[0];

    @Override
    public int compare(Object o1, Object o2) {
        byte[] o2Bytes;
        byte[] o1Bytes = this.getBytes(o1);
        if (o1Bytes == (o2Bytes = this.getBytes(o2))) {
            return 0;
        }
        if (o1Bytes == MIN_BYTES) {
            return -1;
        }
        if (o2Bytes == MIN_BYTES) {
            return 1;
        }
        if (o1Bytes == MAX_BYTES) {
            return 1;
        }
        if (o2Bytes == MAX_BYTES) {
            return -1;
        }
        for (int i = 0; i < o1Bytes.length; ++i) {
            if (i > o2Bytes.length) {
                return 1;
            }
            int result = o1Bytes[i] - o2Bytes[i];
            if (result == 0) continue;
            return result;
        }
        return o2Bytes.length > o1Bytes.length ? 1 : 0;
    }

    private byte[] getBytes(Object o) {
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        if (o instanceof CachedDeserializable) {
            return ((CachedDeserializable)o).getSerializedValue();
        }
        return EntryEventImpl.serialize(o);
    }
}

