/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gemfire.internal.cache.persistence.UninterruptibleFileChannel;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;

public class UninterruptibleRandomAccessFile {
    private RandomAccessFile raf;
    private final UninterruptibleFileChannelImpl channel;
    private final File file;
    private final String mode;
    private boolean isClosed;

    public UninterruptibleRandomAccessFile(File file, String mode) throws FileNotFoundException {
        this.file = file;
        this.mode = mode;
        this.raf = new RandomAccessFile(file, mode);
        this.channel = new UninterruptibleFileChannelImpl();
    }

    public UninterruptibleFileChannel getChannel() {
        return this.channel;
    }

    public synchronized void reopen(long lastPosition) throws IOException {
        if (this.isClosed) {
            throw new IOException("Random Access File is closed");
        }
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.raf = new RandomAccessFile(this.file, this.mode);
        this.raf.seek(lastPosition);
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.raf.close();
    }

    public synchronized void setLength(long newLength) throws IOException {
        this.raf.setLength(newLength);
    }

    public synchronized FileDescriptor getFD() throws IOException {
        return this.raf.getFD();
    }

    public synchronized long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public synchronized void seek(long readPosition) throws IOException {
        this.raf.seek(readPosition);
    }

    public synchronized void readFully(byte[] valueBytes) throws IOException {
        this.raf.readFully(valueBytes);
    }

    public synchronized void readFully(byte[] valueBytes, int i, int valueLength) throws IOException {
        this.raf.readFully(valueBytes, i, valueLength);
    }

    public synchronized long length() throws IOException {
        return this.raf.length();
    }

    private class UninterruptibleFileChannelImpl
    implements UninterruptibleFileChannel {
        private UninterruptibleFileChannelImpl() {
        }

        private FileChannel delegate() {
            return UninterruptibleRandomAccessFile.this.raf.getChannel();
        }

        private long doUninterruptibly(FileOperation op) throws IOException {
            boolean interrupted = false;
            try {
                UninterruptibleRandomAccessFile uninterruptibleRandomAccessFile = UninterruptibleRandomAccessFile.this;
                synchronized (uninterruptibleRandomAccessFile) {
                    while (true) {
                        interrupted |= Thread.interrupted();
                        FileChannel d = this.delegate();
                        long lastPosition = UninterruptibleRandomAccessFile.this.getFilePointer();
                        try {
                            long l = op.doOp(d);
                            return l;
                        }
                        catch (ClosedByInterruptException e) {
                            interrupted = true;
                            UninterruptibleRandomAccessFile.this.reopen(lastPosition);
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        @Override
        public long read(final ByteBuffer[] dsts, final int offset, final int length) throws IOException {
            return this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.read(dsts, offset, length);
                }
            });
        }

        @Override
        public long read(final ByteBuffer[] dsts) throws IOException {
            return this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.read(dsts);
                }
            });
        }

        @Override
        public long write(final ByteBuffer[] srcs, final int offset, final int length) throws IOException {
            return this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.write(srcs, offset, length);
                }
            });
        }

        @Override
        public long write(final ByteBuffer[] srcs) throws IOException {
            return this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.write(srcs);
                }
            });
        }

        @Override
        public int read(final ByteBuffer dst) throws IOException {
            return (int)this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.read(dst);
                }
            });
        }

        @Override
        public int write(final ByteBuffer src) throws IOException {
            return (int)this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.write(src);
                }
            });
        }

        @Override
        public long position() throws IOException {
            return this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.position();
                }
            });
        }

        @Override
        public SeekableByteChannel position(final long newPosition) throws IOException {
            this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    channel.position(newPosition);
                    return 0L;
                }
            });
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    return channel.size();
                }
            });
        }

        @Override
        public SeekableByteChannel truncate(final long size2) throws IOException {
            this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    channel.truncate(size2);
                    return 0L;
                }
            });
            return this;
        }

        @Override
        public boolean isOpen() {
            return this.delegate().isOpen();
        }

        @Override
        public void close() throws IOException {
            UninterruptibleRandomAccessFile.this.close();
        }

        @Override
        public void force(final boolean b) throws IOException {
            this.doUninterruptibly(new FileOperation(){

                @Override
                public long doOp(FileChannel channel) throws IOException {
                    channel.force(b);
                    return 0L;
                }
            });
        }
    }

    private static interface FileOperation {
        public long doOp(FileChannel var1) throws IOException;
    }
}

