/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.persistence;

import com.gemstone.gnu.trove.TIntObjectHashMap;
import com.gemstone.gnu.trove.TObjectIntHashMap;

public class CanonicalIdHolder {
    private TIntObjectHashMap idToObject = new TIntObjectHashMap();
    private TObjectIntHashMap objectToID = new TObjectIntHashMap();
    private int highestID = 0;

    public void addMapping(int id, Object object) {
        this.idToObject.put(id, object);
        this.objectToID.put(object, id);
        this.highestID = this.highestID < id ? id : this.highestID;
    }

    public int getId(Object object) {
        return this.objectToID.get(object);
    }

    public Object getObject(int id) {
        return this.idToObject.get(id);
    }

    public int createId(Object object) {
        assert (!this.objectToID.contains(object));
        int id = ++this.highestID;
        this.objectToID.put(object, id);
        this.idToObject.put(id, object);
        return id;
    }

    public TIntObjectHashMap getAllMappings() {
        return this.idToObject;
    }
}

