/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.GemFireRethrowable;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.streaming.StreamingOperation;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.util.BlobHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public abstract class StreamingPartitionOperation
extends StreamingOperation {
    private static final Logger logger = LogService.getLogger();
    protected final int regionId;

    public StreamingPartitionOperation(InternalDistributedSystem sys, int regionId) {
        super(sys);
        this.regionId = regionId;
    }

    @Override
    public void getDataFromAll(Set recipients) {
        throw new UnsupportedOperationException(LocalizedStrings.StreamingPartitionOperation_CALL_GETPARTITIONEDDATAFROM_INSTEAD.toLocalizedString());
    }

    public Set<InternalDistributedMember> getPartitionedDataFrom(Set recipients) throws TimeoutException, InterruptedException, QueryException, ForceReattemptException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (recipients.isEmpty()) {
            return Collections.emptySet();
        }
        StreamingPartitionResponse processor = new StreamingPartitionResponse(this.sys, recipients);
        DistributionMessage m = this.createRequestMessage(recipients, processor);
        this.sys.getDistributionManager().putOutgoing(m);
        Set<InternalDistributedMember> failedMembers = processor.waitForCacheOrQueryException();
        return failedMembers;
    }

    @Override
    protected abstract DistributionMessage createRequestMessage(Set var1, ReplyProcessor21 var2);

    public static abstract class StreamingPartitionMessage
    extends PartitionMessage {
        transient HeapDataOutputStream outStream = null;
        transient int replyMsgNum = 0;
        transient boolean replyLastMsg = true;
        transient int numObjectsInChunk = 0;

        public StreamingPartitionMessage() {
        }

        public StreamingPartitionMessage(Set recipients, int regionId, ReplyProcessor21 processor) {
            super(recipients, regionId, processor);
        }

        public StreamingPartitionMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor) {
            super(recipient, regionId, processor);
        }

        @Override
        protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr2, long startTime) {
            if (ex != null) {
                this.outStream = null;
                this.replyMsgNum = 0;
                this.replyLastMsg = true;
            }
            if (this.replyLastMsg && pr2 != null && startTime > 0L) {
                pr2.getPrStats().endPartitionMessagesProcessing(startTime);
            }
            StreamingOperation.StreamingReplyMessage.send(member, procId, ex, dm, this.outStream, this.numObjectsInChunk, this.replyMsgNum, this.replyLastMsg);
        }

        @Override
        protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
            boolean isTraceEnabled = logger.isTraceEnabled();
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Object failedObject = null;
            int socketBufferSize = dm.getSystem().getConfig().getSocketBufferSize();
            int chunkSize = socketBufferSize - 200;
            boolean sentFinalMessage = false;
            boolean receiverCacheClosed = false;
            this.outStream = new HeapDataOutputStream(chunkSize, this.getSender().getVersionObject());
            try {
                do {
                    block15: {
                        Object nextObject;
                        if (failedObject == null) {
                            nextObject = this.getNextReplyObject(pr2);
                            this.replyLastMsg = nextObject == Token.END_OF_STREAM;
                        } else {
                            nextObject = failedObject;
                            failedObject = null;
                        }
                        if (!this.replyLastMsg) {
                            this.numObjectsInChunk = 1;
                            if (isTraceEnabled) {
                                logger.trace("Writing this object to StreamingPartitionMessage outStream: '{}'", nextObject);
                            }
                            BlobHelper.serializeTo(nextObject, this.outStream);
                            do {
                                this.outStream.disallowExpansion(StreamingOperation.CHUNK_FULL);
                                nextObject = this.getNextReplyObject(pr2);
                                boolean bl = this.replyLastMsg = nextObject == Token.END_OF_STREAM;
                                if (this.replyLastMsg) continue;
                                try {
                                    if (isTraceEnabled) {
                                        logger.trace("Writing this object to StreamingPartitionMessage outStream: '{}'", nextObject);
                                    }
                                    BlobHelper.serializeTo(nextObject, this.outStream);
                                    ++this.numObjectsInChunk;
                                }
                                catch (GemFireRethrowable e) {
                                    failedObject = nextObject;
                                    break;
                                }
                            } while (nextObject != Token.END_OF_STREAM);
                        }
                        try {
                            this.sendReply(this.getSender(), this.processorId, dm, null, pr2, startTime);
                            ++this.replyMsgNum;
                            if (!this.replyLastMsg) break block15;
                            sentFinalMessage = true;
                        }
                        catch (CancelException e) {
                            receiverCacheClosed = true;
                            break;
                        }
                    }
                    this.outStream.reset();
                    this.numObjectsInChunk = 0;
                } while (!this.replyLastMsg);
            }
            catch (IOException ioe) {
                throw new InternalGemFireException(ioe);
            }
            if (!sentFinalMessage && !receiverCacheClosed) {
                throw new InternalGemFireError(LocalizedStrings.StreamingPartitionOperation_UNEXPECTED_CONDITION.toLocalizedString());
            }
            return false;
        }

        protected abstract Object getNextReplyObject(PartitionedRegion var1) throws CacheException, ForceReattemptException, InterruptedException;

        protected Object getNextReplyObject() {
            throw new UnsupportedOperationException(LocalizedStrings.StreamingPartitionOperation_USE_GETNEXTREPLYOBJECTPARTITIONEDREGION_INSTEAD.toLocalizedString());
        }
    }

    protected class StreamingPartitionResponse
    extends ReplyProcessor21 {
        protected volatile boolean abort;
        protected final Map statusMap;
        protected final AtomicInteger msgsBeingProcessed;
        private volatile String memberDepartedMessage;
        private final Set<InternalDistributedMember> failedMembers;
        private volatile boolean finishedWaiting;

        public StreamingPartitionResponse(InternalDistributedSystem system, Set members) {
            super(system, (Collection)members);
            this.abort = false;
            this.statusMap = new HashMap();
            this.msgsBeingProcessed = new AtomicInteger();
            this.memberDepartedMessage = null;
            this.failedMembers = new CopyOnWriteHashSet<InternalDistributedMember>();
            this.finishedWaiting = false;
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (!this.waitingOnMember(msg.getSender())) {
                return;
            }
            this.msgsBeingProcessed.incrementAndGet();
            try {
                StreamingOperation.StreamingReplyMessage m = (StreamingOperation.StreamingReplyMessage)msg;
                boolean isLast = true;
                List objects = m.getObjects();
                if (objects != null) {
                    boolean isAborted = this.abort;
                    if (!isAborted) {
                        boolean bl = isAborted = !StreamingPartitionOperation.this.processChunk(objects, m.getSender(), m.getMessageNumber(), m.isLastMessage());
                        if (isAborted) {
                            this.abort = true;
                        }
                    }
                    isLast = isAborted || this.trackMessage(m);
                } else {
                    isLast = true;
                }
                if (isLast) {
                    super.process(msg, false);
                }
            }
            finally {
                this.msgsBeingProcessed.decrementAndGet();
                this.checkIfDone();
            }
        }

        @Override
        protected synchronized void processException(DistributionMessage msg, ReplyException ex) {
            Throwable t = ex.getCause();
            if (t instanceof ForceReattemptException || t instanceof CacheClosedException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("StreamingPartitionResponse received exception {} for member {} query retry required.", t, msg.getSender());
                }
                this.failedMembers.add(msg.getSender());
            } else {
                super.processException(msg, ex);
            }
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            if (id != null && this.waitingOnMember(id)) {
                this.failedMembers.add(id);
                this.memberDepartedMessage = LocalizedStrings.StreamingPartitionOperation_GOT_MEMBERDEPARTED_EVENT_FOR_0_CRASHED_1.toLocalizedString(id, crashed);
            }
            super.memberDeparted(id, crashed);
        }

        public Set<InternalDistributedMember> waitForCacheOrQueryException() throws CacheException, QueryException {
            try {
                this.waitForRepliesUninterruptibly();
                return this.failedMembers;
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CacheException) {
                    throw (CacheException)t;
                }
                if (t instanceof RegionDestroyedException) {
                    throw (RegionDestroyedException)t;
                }
                if (t instanceof QueryException) {
                    throw (QueryException)t;
                }
                if (t instanceof PrimaryBucketException) {
                    throw new PrimaryBucketException("Peer failed primary test", t);
                }
                e.handleAsUnexpected();
                throw e;
            }
        }

        @Override
        protected boolean stillWaiting() {
            if (this.finishedWaiting) {
                return false;
            }
            if (this.msgsBeingProcessed.get() > 0 && this.numMembers() > 0) {
                return true;
            }
            this.finishedWaiting = this.finishedWaiting || this.abort || !super.stillWaiting();
            return !this.finishedWaiting;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(this.getClass().getName());
            sb.append(" ");
            sb.append(Integer.toString(this.getProcessorId()));
            if (this.members == null) {
                sb.append(" (null memebrs)");
            } else {
                sb.append(" waiting for ");
                sb.append(Integer.toString(this.numMembers()));
                sb.append(" replies");
                sb.append(this.exception == null ? "" : " exception: " + this.exception);
                sb.append(" from ");
                sb.append(this.membersToString());
            }
            sb.append("; waiting for ");
            sb.append(Integer.toString(this.msgsBeingProcessed.get()));
            sb.append(" messages in the process of being processed>");
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean trackMessage(StreamingOperation.StreamingReplyMessage m) {
            Status status;
            StreamingPartitionResponse streamingPartitionResponse = this;
            synchronized (streamingPartitionResponse) {
                status = (Status)this.statusMap.get(m.getSender());
                if (status == null) {
                    status = new Status();
                    this.statusMap.put(m.getSender(), status);
                }
            }
            return status.trackMessage(m);
        }

        public void removeFailedSenders(Set notReceivedMembers) {
            Iterator i = notReceivedMembers.iterator();
            while (i.hasNext()) {
                this.removeMember((InternalDistributedMember)i.next(), true);
            }
        }

        class Status {
            int msgsProcessed = 0;
            int numMsgs = 0;

            Status() {
            }

            protected synchronized boolean trackMessage(StreamingOperation.StreamingReplyMessage m) {
                ++this.msgsProcessed;
                if (m.isLastMessage()) {
                    this.numMsgs = m.getMessageNumber() + 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Streaming Message Tracking Status: Processor id: {}; Sender: {}; Messages Processed: {}; NumMsgs: {}", StreamingPartitionResponse.this.getProcessorId(), m.getSender(), this.msgsProcessed, this.numMsgs);
                }
                return this.msgsProcessed == this.numMsgs;
            }
        }
    }
}

