/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.LoadProbe;
import com.gemstone.gemfire.internal.cache.partitioned.PRLoad;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SizedBasedLoadProbe
implements LoadProbe,
DataSerializableFixedID {
    private static final long serialVersionUID = 7040814060882774875L;
    public static final int MIN_BUCKET_SIZE = Integer.getInteger("gemfire.MIN_BUCKET_SIZE", 1);

    @Override
    public PRLoad getLoad(PartitionedRegion pr2) {
        PartitionedRegionDataStore ds = pr2.getDataStore();
        int configuredBucketCount = pr2.getTotalNumberOfBuckets();
        PRLoad prLoad = new PRLoad(configuredBucketCount, pr2.getLocalMaxMemory());
        for (Integer bidInt : ds.getAllLocalBucketIds()) {
            int bid = bidInt;
            long bucketSize = ds.getBucketSize(bid);
            if (bucketSize < (long)MIN_BUCKET_SIZE) {
                bucketSize = MIN_BUCKET_SIZE;
            }
            BucketAdvisor bucketAdvisor = pr2.getRegionAdvisor().getBucket(bid).getBucketAdvisor();
            bucketAdvisor.getPrimary();
            boolean isPrimary = pr2.getRegionAdvisor().getBucket(bid).getBucketAdvisor().isPrimary();
            prLoad.addBucket(bid, bucketSize, isPrimary ? 1.0f : 0.0f);
        }
        return prLoad;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public int getDSFID() {
        return -123;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

