/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class RemoveBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private boolean forceRemovePrimary;

    public RemoveBucketMessage() {
    }

    private RemoveBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, boolean forceRemovePrimary) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.forceRemovePrimary = forceRemovePrimary;
    }

    public static RemoveBucketResponse send(InternalDistributedMember recipient, PartitionedRegion region, int bucketId, boolean forceRemovePrimary) {
        Assert.assertTrue(recipient != null, "RemoveBucketMessage NULL recipient");
        RemoveBucketResponse response = new RemoveBucketResponse(region.getSystem(), recipient, region);
        RemoveBucketMessage msg = new RemoveBucketMessage(recipient, region.getPRId(), response, bucketId, forceRemovePrimary);
        Set failures = region.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        region.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public RemoveBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        PartitionedRegionDataStore dataStore = region.getDataStore();
        boolean removed = dataStore.removeBucket(this.bucketId, this.forceRemovePrimary);
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        RemoveBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, null, removed);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 134;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.forceRemovePrimary = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeBoolean(this.forceRemovePrimary);
    }

    public static class RemoveBucketResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean removed = false;

        public RemoveBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof RemoveBucketReplyMessage) {
                    RemoveBucketReplyMessage reply = (RemoveBucketReplyMessage)msg;
                    this.removed = reply.removed();
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.debug("RemoveBucketResponse is {}", this.removed);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("RemoveBucketMessage ignoring exception: {}", ex.getMessage(), ex);
        }

        public boolean waitForResponse() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    String msg = "RemoveBucketMessage got remote cancellation,";
                    logger.debug(msg, t);
                    return true;
                }
                if (t instanceof PRLocallyDestroyedException) {
                    String msg = "RemoveBucketMessage got local destroy on the PartitionRegion ";
                    logger.debug(msg, t);
                    return true;
                }
                if (t instanceof ForceReattemptException) {
                    String msg = "RemoveBucketMessage got ForceReattemptException due to local destroy on the PartitionRegion";
                    logger.debug(msg, t);
                    return true;
                }
                e.handleAsUnexpected();
            }
            return this.removed;
        }
    }

    public static final class RemoveBucketReplyMessage
    extends ReplyMessage {
        private boolean removed;

        public RemoveBucketReplyMessage() {
        }

        public RemoveBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private RemoveBucketReplyMessage(int processorId, ReplyException re, boolean removed) {
            this.processorId = processorId;
            this.removed = removed;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException re, boolean removed) {
            Assert.assertTrue(recipient != null, "RemoveBucketReplyMessage NULL recipient");
            RemoveBucketReplyMessage m = new RemoveBucketReplyMessage(processorId, re, removed);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean removed() {
            return this.removed;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("RemoveBucketReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.debug("RemoveBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.removed);
        }

        @Override
        public int getDSFID() {
            return 135;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.removed = in.readBoolean();
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("RemoveBucketReplyMessage ").append("processorid=").append(this.processorId).append(" removed=").append(this.removed).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

