/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.PRQueryTraceInfo;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.streaming.StreamingOperation;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PRQueryProcessor;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.partitioned.StreamingPartitionOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public final class QueryMessage
extends StreamingPartitionOperation.StreamingPartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile String queryString;
    private volatile boolean cqQuery;
    private volatile Object[] parameters;
    private volatile List buckets;
    private volatile boolean isPdxSerialized;
    private volatile boolean traceOn;
    private transient Collection<Collection> resultCollector = new ArrayList<Collection>();
    private transient int tokenCount = 0;
    private transient Iterator currentResultIterator;
    private transient Iterator<Collection> currentSelectResultIterator;

    public QueryMessage() {
    }

    public QueryMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, DefaultQuery query, Object[] parameters, List buckets) {
        super(recipient, regionId, processor);
        this.queryString = query.getQueryString();
        this.buckets = buckets;
        this.parameters = parameters;
        this.cqQuery = query.isCqQuery();
        this.traceOn = query.isTraced() || DefaultQuery.QUERY_VERBOSE;
    }

    @Override
    protected Object getNextReplyObject(PartitionedRegion pr2) throws CacheException, ForceReattemptException, InterruptedException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (QueryMonitor.isLowMemory()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(QueryMonitor.getMemoryUsedDuringLowMemory());
            throw new QueryExecutionLowMemoryException(reason);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        while (this.currentResultIterator == null || !this.currentResultIterator.hasNext()) {
            if (this.currentSelectResultIterator.hasNext()) {
                Collection results = this.currentSelectResultIterator.next();
                if (isDebugEnabled) {
                    logger.debug("Query result size: {}", results.size());
                }
                this.currentResultIterator = results.iterator();
                continue;
            }
            return Token.END_OF_STREAM;
        }
        return this.currentResultIterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, QueryException, ForceReattemptException, InterruptedException {
        long traceStartTime = 0L;
        if (this.traceOn) {
            traceStartTime = NanoTimer.getTime();
        }
        PRQueryTraceInfo queryTraceInfo = null;
        List<PRQueryTraceInfo> queryTraceList = null;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "QueryMessage operateOnPartitionedRegion: {} buckets {}", r.getFullPath(), this.buckets);
        }
        r.waitOnInitialization();
        if (QueryMonitor.isLowMemory()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(QueryMonitor.getMemoryUsedDuringLowMemory());
            throw new QueryExecutionLowMemoryException(reason);
        }
        DefaultQuery query = new DefaultQuery(this.queryString, r.getCache());
        DefaultQuery.setPdxReadSerialized(r.getCache(), true);
        query.setRemoteQuery(true);
        QueryObserver indexObserver = query.startTrace();
        try {
            query.setIsCqQuery(this.cqQuery);
            PRQueryProcessor qp = new PRQueryProcessor(r, query, this.parameters, this.buckets);
            if (logger.isDebugEnabled()) {
                logger.debug("Started executing query from remote node: {}", query.getQueryString());
            }
            if (query.isTraced() && this.sender.getVersionObject().compareTo(Version.GFE_81) >= 0) {
                if (DefaultQuery.testHook != null) {
                    DefaultQuery.testHook.doTestHook("Create PR Query Trace Info for Remote Query");
                }
                queryTraceInfo = new PRQueryTraceInfo();
                queryTraceList = Collections.singletonList(queryTraceInfo);
                this.resultCollector.add(queryTraceList);
            }
            qp.executeQuery(this.resultCollector);
            this.currentSelectResultIterator = this.resultCollector.iterator();
            if (query.isTraced() && this.sender.getVersionObject().compareTo(Version.GFE_81) >= 0) {
                if (DefaultQuery.testHook != null) {
                    DefaultQuery.testHook.doTestHook("Populating Trace Info for Remote Query");
                }
                int traceSize = 0;
                traceSize = queryTraceInfo.calculateNumberOfResults(this.resultCollector);
                queryTraceInfo.setTimeInMillis((float)(NanoTimer.getTime() - traceStartTime) / 1000000.0f);
                queryTraceInfo.setNumResults(--traceSize);
                if (indexObserver instanceof IndexTrackingQueryObserver) {
                    Map indexesUsed = ((IndexTrackingQueryObserver)indexObserver).getUsedIndexes();
                    StringBuffer buf = new StringBuffer();
                    buf.append(" indexesUsed(").append(indexesUsed.size()).append(")");
                    if (indexesUsed.size() > 0) {
                        buf.append(":");
                        Iterator itr = indexesUsed.entrySet().iterator();
                        while (itr.hasNext()) {
                            Map.Entry entry = itr.next();
                            buf.append(entry.getKey().toString() + entry.getValue());
                            if (!itr.hasNext()) continue;
                            buf.append(",");
                        }
                    }
                    queryTraceInfo.setIndexesUsed(buf.toString());
                }
            }
            if (QueryMonitor.isLowMemory()) {
                String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(QueryMonitor.getMemoryUsedDuringLowMemory());
                throw new QueryExecutionLowMemoryException(reason);
            }
            super.operateOnPartitionedRegion(dm, r, startTime);
        }
        finally {
            if (query.isTraced() && this.sender.getVersionObject().compareTo(Version.GFE_81) >= 0) {
                this.resultCollector.remove(queryTraceList);
            }
            DefaultQuery.setPdxReadSerialized(r.getCache(), false);
            query.setRemoteQuery(false);
            query.endTrace(indexObserver, traceStartTime, this.resultCollector);
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; query=").append(this.queryString).append("; bucketids=").append(this.buckets);
    }

    @Override
    public int getDSFID() {
        return 58;
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DM dm, ReplyException ex, PartitionedRegion pr2, long startTime) {
        if (ex != null) {
            this.outStream = null;
            this.replyMsgNum = 0;
            this.replyLastMsg = true;
        }
        if (this.replyLastMsg && pr2 != null && startTime > 0L) {
            pr2.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        StreamingOperation.StreamingReplyMessage.send(member, procId, ex, dm, this.outStream, this.numObjectsInChunk, this.replyMsgNum, this.replyLastMsg, this.isPdxSerialized);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.queryString = DataSerializer.readString(in);
        this.buckets = DataSerializer.readArrayList(in);
        this.parameters = DataSerializer.readObjectArray(in);
        this.cqQuery = DataSerializer.readBoolean(in);
        this.isPdxSerialized = DataSerializer.readBoolean(in);
        this.traceOn = DataSerializer.readBoolean(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.queryString, out);
        DataSerializer.writeArrayList((ArrayList)this.buckets, out);
        DataSerializer.writeObjectArray(this.parameters, out);
        DataSerializer.writeBoolean(this.cqQuery, out);
        DataSerializer.writeBoolean(true, out);
        DataSerializer.writeBoolean(this.traceOn, out);
    }
}

