/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class PrimaryRequestMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    private int bucketId;

    public static PrimaryResponse send(Set recipients, PartitionedRegion r, int bucketId) throws ForceReattemptException {
        Assert.assertTrue(recipients != null, "PrimaryRequestMessage NULL recipient");
        PrimaryResponse p = new PrimaryResponse(r.getSystem(), recipients);
        PrimaryRequestMessage m = new PrimaryRequestMessage(recipients, r.getPRId(), p, bucketId);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.PrimaryRequestMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public PrimaryRequestMessage() {
    }

    private PrimaryRequestMessage(Set recipients, int regionId, ReplyProcessor21 processor, int bId) {
        super(recipients, regionId, processor);
        this.bucketId = bId;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException, ForceReattemptException {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "PrimaryRequestMessage operateOnRegion: {}", pr2.getFullPath());
        }
        pr2.checkReadiness();
        boolean isPrimary = dm.getId().equals(pr2.getBucketPrimary(this.bucketId));
        PrimaryRequestReplyMessage.sendReply(this.getSender(), this.getProcessorId(), isPrimary, dm);
        return false;
    }

    @Override
    public int getDSFID() {
        return 54;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    public static class PrimaryResponse
    extends ReplyProcessor21 {
        private volatile PrimaryRequestReplyMessage msg;

        protected PrimaryResponse(InternalDistributedSystem ds, Set recipients) {
            super(ds, (Collection)recipients);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof PrimaryRequestReplyMessage) {
                    PrimaryRequestReplyMessage reply = (PrimaryRequestReplyMessage)msg;
                    if (reply.isPrimary) {
                        this.msg = reply;
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.trace(LogMarker.DM, "PrimaryRequestResponse primary is {}", this.msg.getSender());
                        }
                    } else if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.debug("PrimaryRequestResponse {} is not primary", this.msg.getSender());
                    }
                } else {
                    Assert.assertTrue(msg instanceof ReplyMessage);
                }
            }
            finally {
                super.process(msg);
            }
        }

        public InternalDistributedMember waitForPrimary() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "NodeResponse got remote CacheClosedException, throwing PartitionedRegionCommunication Exception. {}", t.getMessage(), t);
                    }
                    throw new ForceReattemptException(LocalizedStrings.PrimaryRequestMessage_NODERESPONSE_GOT_REMOTE_CACHECLOSEDEXCEPTION_THROWING_PARTITIONEDREGIONCOMMUNICATION_EXCEPTION.toLocalizedString(), t);
                }
                e.handleAsUnexpected();
            }
            return this.msg.getSender();
        }
    }

    public static final class PrimaryRequestReplyMessage
    extends ReplyMessage {
        private static final long serialVersionUID = 1L;
        public volatile boolean isPrimary;

        protected static void sendReply(InternalDistributedMember member, int procId, boolean isPrimary, DM dm) {
            dm.putOutgoing(new PrimaryRequestReplyMessage(member, procId, isPrimary));
        }

        public PrimaryRequestReplyMessage() {
        }

        private PrimaryRequestReplyMessage(InternalDistributedMember member, int procId, boolean isPrimary2) {
            this.setRecipient(member);
            this.setProcessorId(procId);
            this.isPrimary = isPrimary2;
        }

        @Override
        public int getDSFID() {
            return 55;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.isPrimary = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.isPrimary);
        }
    }
}

