/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPRInfo;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPartitionDetails;
import com.gemstone.gemfire.internal.cache.partitioned.OfflineMemberDetails;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;

public class PartitionRegionInfoImpl
implements InternalPRInfo,
Serializable {
    private static final long serialVersionUID = 6462414089469761476L;
    private final String regionPath;
    private final int configuredBucketCount;
    private final int createdBucketCount;
    private final int lowRedundancyBucketCount;
    private final int configuredRedundantCopies;
    private final int actualRedundantCopies;
    private final Set<InternalPartitionDetails> memberDetails;
    private final String colocatedWith;
    private final OfflineMemberDetails offlineMembers;

    public PartitionRegionInfoImpl(String regionPath, int configuredBucketCount, int createdBucketCount, int lowRedundancyBucketCount, int configuredRedundantCopies, int actualRedundantCopies, Set<InternalPartitionDetails> memberDetails, String colocatedPath, OfflineMemberDetails offlineMembers) {
        this.regionPath = regionPath;
        this.configuredBucketCount = configuredBucketCount;
        this.createdBucketCount = createdBucketCount;
        this.lowRedundancyBucketCount = lowRedundancyBucketCount;
        this.configuredRedundantCopies = configuredRedundantCopies;
        this.actualRedundantCopies = actualRedundantCopies;
        this.memberDetails = memberDetails;
        this.colocatedWith = colocatedPath;
        this.offlineMembers = offlineMembers;
    }

    @Override
    public int getActualRedundantCopies() {
        return this.actualRedundantCopies;
    }

    @Override
    public String getColocatedWith() {
        return this.colocatedWith;
    }

    @Override
    public int getConfiguredBucketCount() {
        return this.configuredBucketCount;
    }

    @Override
    public int getConfiguredRedundantCopies() {
        return this.configuredRedundantCopies;
    }

    @Override
    public int getCreatedBucketCount() {
        return this.createdBucketCount;
    }

    @Override
    public int getLowRedundancyBucketCount() {
        return this.lowRedundancyBucketCount;
    }

    @Override
    public Set<PartitionMemberInfo> getPartitionMemberInfo() {
        return Collections.unmodifiableSet(this.memberDetails);
    }

    @Override
    public Set<InternalPartitionDetails> getInternalPartitionDetails() {
        return Collections.unmodifiableSet(this.memberDetails);
    }

    @Override
    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public OfflineMemberDetails getOfflineMembers() {
        return this.offlineMembers;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[PartitionRegionInfoImpl: ");
        sb.append("regionPath=").append(this.regionPath);
        sb.append(", configuredBucketCount=").append(this.configuredBucketCount);
        sb.append(", createdBucketCount=").append(this.createdBucketCount);
        sb.append(", lowRedundancyBucketCount=").append(this.lowRedundancyBucketCount);
        sb.append(", configuredRedundantCopies=").append(this.configuredRedundantCopies);
        sb.append(", actualRedundantCopies=").append(this.actualRedundantCopies);
        sb.append(", memberDetails=").append(this.memberDetails);
        sb.append(", colocatedWith=").append(this.colocatedWith);
        sb.append(", offlineMembers=").append(this.offlineMembers);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.regionPath.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PartitionRegionInfoImpl)) {
            return false;
        }
        PartitionRegionInfoImpl o = (PartitionRegionInfoImpl)other;
        return this.regionPath.equals(o.regionPath);
    }

    @Override
    public int compareTo(InternalPRInfo other) {
        return this.regionPath.compareTo(other.getRegionPath());
    }
}

