/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class IdentityRequestMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final int UNINITIALIZED = -1;
    private static int latestId = -1;
    private int processorId;

    public static synchronized void setLatestId(int newlatest) {
        if (newlatest > latestId) {
            latestId = newlatest;
        }
    }

    public static synchronized int getLatestId() {
        return latestId;
    }

    public IdentityRequestMessage() {
    }

    public IdentityRequestMessage(Set recipients, int processorId) {
        this.setRecipients(recipients);
        this.processorId = processorId;
    }

    @Override
    protected void process(DistributionManager dm) {
        try {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{}: processing message {}", this.getClass().getName(), this);
            }
            IdentityReplyMessage.send(this.getSender(), this.getProcessorId(), dm);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.debug("{} Caught throwable {}", this, t.getMessage(), t);
        }
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getProcessorType() {
        return 75;
    }

    public static IdentityResponse send(Set recipients, InternalDistributedSystem is) {
        Assert.assertTrue(recipients != null, "IdentityMessage NULL recipients set");
        int i = 0;
        Iterator ri = recipients.iterator();
        while (ri.hasNext()) {
            Assert.assertTrue(null != ri.next(), "IdenityMessage recipient " + i + " is null");
            ++i;
        }
        IdentityResponse p = new IdentityResponse(is, recipients);
        IdentityRequestMessage m = new IdentityRequestMessage(recipients, p.getProcessorId());
        is.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    public int getDSFID() {
        return 50;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.processorId);
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("(sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append(")").toString();
    }

    public static class IdentityResponse
    extends ReplyProcessor21 {
        private Integer returnValue;

        public IdentityResponse(InternalDistributedSystem system, Set initMembers) {
            super(system, (Collection)initMembers);
            int localIdent = IdentityRequestMessage.getLatestId();
            if (localIdent != -1) {
                this.returnValue = localIdent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            block11: {
                try {
                    if (!(msg instanceof IdentityReplyMessage)) break block11;
                    IdentityReplyMessage reply = (IdentityReplyMessage)msg;
                    Integer remoteId = reply.getId();
                    IdentityResponse identityResponse = this;
                    synchronized (identityResponse) {
                        if (remoteId != null) {
                            if (this.returnValue == null) {
                                this.returnValue = remoteId;
                            } else if (remoteId > this.returnValue) {
                                this.returnValue = remoteId;
                            }
                        }
                    }
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "{} return value is {}", this.getClass().getName(), this.returnValue);
                    }
                }
                finally {
                    super.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer waitForId() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                logger.debug("{} waitBucketSizes ignoring exception {}", this.getClass().getName(), e.getMessage(), e);
            }
            IdentityResponse identityResponse = this;
            synchronized (identityResponse) {
                return this.returnValue;
            }
        }
    }

    public static final class IdentityReplyMessage
    extends HighPriorityDistributionMessage {
        private int Id = -1;
        private int processorId;

        public IdentityReplyMessage() {
        }

        private IdentityReplyMessage(int processorId) {
            this.processorId = processorId;
            this.Id = IdentityRequestMessage.getLatestId();
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm) {
            Assert.assertTrue(recipient != null, "IdentityReplyMessage NULL reply message");
            IdentityReplyMessage m = new IdentityReplyMessage(processorId);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        protected void process(DistributionManager dm) {
            ReplyProcessor21 processor;
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} process invoking reply processor with processorId:{}", this.getClass().getName(), this.processorId);
            }
            if ((processor = ReplyProcessor21.getProcessor(this.processorId)) == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "Processor not found: {}", this.getClass().getName());
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            out.writeInt(this.Id);
        }

        @Override
        public int getDSFID() {
            return 67;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.Id = in.readInt();
        }

        @Override
        public String toString() {
            return new StringBuffer().append(this.getClass().getName()).append("(sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; PRId=").append(this.getId()).append(")").toString();
        }

        public Integer getId() {
            if (this.Id == -1) {
                return null;
            }
            return this.Id;
        }
    }
}

