/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.DataLocationException;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyInfo;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class FetchEntryMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private boolean access;
    protected static final int HAS_ACCESS = 1024;

    public FetchEntryMessage() {
    }

    private FetchEntryMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, Object key2, boolean access) {
        super(recipient, regionId, processor);
        this.key = key2;
        this.access = access;
    }

    public static FetchEntryResponse send(InternalDistributedMember recipient, PartitionedRegion r, Object key2, boolean access) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "FetchEntryMessage NULL recipient");
        FetchEntryResponse p = new FetchEntryResponse(r.getSystem(), Collections.singleton(recipient), r, key2);
        FetchEntryMessage m = new FetchEntryMessage(recipient, r.getPRId(), p, key2, access);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.FetchEntryMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    public FetchEntryMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws ForceReattemptException {
        PartitionedRegionDataStore ds = r.getDataStore();
        if (ds != null) {
            try {
                if (r.keyRequiresRegionContext()) {
                    ((KeyWithRegionContext)this.key).setRegionContext(r);
                }
                KeyInfo keyInfo = r.getKeyInfo(this.key);
                EntrySnapshot val = (EntrySnapshot)r.getDataView().getEntryOnRemote(keyInfo, r, true);
                r.getPrStats().endPartitionMessagesProcessing(startTime);
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), val, dm, null);
            }
            catch (TransactionException tex) {
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(tex));
            }
            catch (PRLocallyDestroyedException pde) {
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(new ForceReattemptException(LocalizedStrings.FetchEntryMessage_ENCOUNTERED_PRLOCALLYDESTROYED.toLocalizedString(), pde)));
            }
            catch (EntryNotFoundException enfe) {
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(LocalizedStrings.FetchEntryMessage_ENTRY_NOT_FOUND.toLocalizedString(), enfe));
            }
            catch (PrimaryBucketException pbe) {
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(pbe));
            }
            catch (ForceReattemptException pbe) {
                pbe.checkKey(this.key);
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(pbe));
            }
            catch (DataLocationException e) {
                FetchEntryReplyMessage.send(this.getSender(), this.getProcessorId(), null, dm, new ReplyException(e));
            }
        } else {
            throw new InternalGemFireError(LocalizedStrings.FetchEntryMessage_FETCHENTRYMESSAGE_MESSAGE_SENT_TO_WRONG_MEMBER.toLocalizedString());
        }
        return false;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.key);
    }

    @Override
    public int getDSFID() {
        return 47;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
    }

    @Override
    protected void setBooleans(short s, DataInput in) throws IOException, ClassNotFoundException {
        super.setBooleans(s, in);
        this.access = (s & 0x400) != 0;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.access) {
            s = (short)(s | 0x400);
        }
        return s;
    }

    public final void setKey(Object key2) {
        this.key = key2;
    }

    public static class FetchEntryResponse
    extends PartitionMessage.PartitionResponse {
        private volatile EntrySnapshot returnValue;
        final PartitionedRegion partitionedRegion;
        final Object key;

        public FetchEntryResponse(InternalDistributedSystem ds, Set recipients, PartitionedRegion theRegion, Object key2) {
            super(ds, recipients);
            this.partitionedRegion = theRegion;
            this.key = key2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof FetchEntryReplyMessage) {
                    FetchEntryReplyMessage reply = (FetchEntryReplyMessage)msg;
                    this.returnValue = reply.getValue();
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "FetchEntryResponse return value is {}", this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public EntrySnapshot waitForResponse() throws EntryNotFoundException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                e.checkKey(this.key);
                String msg = "FetchEntryResponse got remote ForceReattemptException; rethrowing";
                logger.debug("FetchEntryResponse got remote ForceReattemptException; rethrowing", (Throwable)e);
                throw e;
            }
            catch (EntryNotFoundException e) {
                throw e;
            }
            catch (TransactionException e) {
                throw e;
            }
            catch (CacheException ce) {
                logger.debug("FetchEntryResponse got remote CacheException; forcing reattempt.", (Throwable)ce);
                throw new ForceReattemptException(LocalizedStrings.FetchEntryMessage_FETCHENTRYRESPONSE_GOT_REMOTE_CACHEEXCEPTION_FORCING_REATTEMPT.toLocalizedString(), ce);
            }
            return this.returnValue;
        }
    }

    public static final class FetchEntryReplyMessage
    extends ReplyMessage {
        private EntrySnapshot value;

        public FetchEntryReplyMessage() {
        }

        public FetchEntryReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private FetchEntryReplyMessage(int processorId, EntrySnapshot value2, ReplyException re) {
            this.processorId = processorId;
            this.value = value2;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, EntrySnapshot value2, DM dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "FetchEntryReplyMessage NULL recipient");
            FetchEntryReplyMessage m = new FetchEntryReplyMessage(processorId, value2, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "FetchEntryReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "FetchEntryReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.debug("{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        public EntrySnapshot getValue() {
            return this.value;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            if (this.value == null) {
                out.writeBoolean(true);
            } else {
                out.writeBoolean(false);
                InternalDataSerializer.invokeToData(this.value, out);
            }
        }

        @Override
        public int getDSFID() {
            return 66;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            boolean nullEntry = in.readBoolean();
            if (!nullEntry) {
                FetchEntryResponse processor = (FetchEntryResponse)ReplyProcessor21.getProcessor(this.processorId);
                if (processor == null) {
                    throw new OperationCancelledException("This operation was cancelled (null processor)");
                }
                this.value = new EntrySnapshot(in, processor.partitionedRegion);
            }
        }

        @Override
        public StringBuilder getStringBuilder() {
            StringBuilder sb = super.getStringBuilder();
            if (this.getException() == null) {
                sb.append(" returning value=").append(this.value);
            }
            return sb;
        }
    }
}

