/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;

public class EndBucketCreationMessage
extends PartitionMessage {
    private int bucketId;
    private InternalDistributedMember newPrimary;

    public EndBucketCreationMessage() {
    }

    private EndBucketCreationMessage(Collection<InternalDistributedMember> recipients, int regionId, ReplyProcessor21 processor, int bucketId, InternalDistributedMember newPrimary) {
        super(recipients, regionId, processor);
        this.bucketId = bucketId;
        this.newPrimary = newPrimary;
    }

    public static void send(Collection<InternalDistributedMember> acceptedMembers, InternalDistributedMember newPrimary, PartitionedRegion pr2, int bid) {
        Assert.assertTrue(newPrimary != null, "VolunteerPrimaryBucketMessage NULL recipient");
        ReplyProcessor21 response = new ReplyProcessor21(pr2.getSystem(), acceptedMembers);
        EndBucketCreationMessage msg = new EndBucketCreationMessage(acceptedMembers, pr2.getPRId(), response, bid, newPrimary);
        pr2.getDistributionManager().putOutgoing(msg);
    }

    public EndBucketCreationMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public int getProcessorType() {
        return 77;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        try {
            region.getRedundancyProvider().endBucketCreationLocally(this.bucketId, this.newPrimary);
        }
        finally {
            region.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
        buff.append("; newPrimary=").append(this.newPrimary);
    }

    @Override
    public int getDSFID() {
        return 2113;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.newPrimary = new InternalDistributedMember();
        InternalDataSerializer.invokeFromData(this.newPrimary, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        InternalDataSerializer.invokeToData(this.newPrimary, out);
    }
}

