/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class DumpBucketsMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    boolean validateOnly;
    boolean bucketsOnly;

    public DumpBucketsMessage() {
    }

    private DumpBucketsMessage(Set recipients, int regionId, ReplyProcessor21 processor, boolean validate, boolean buckets) {
        super(recipients, regionId, processor);
        this.validateOnly = validate;
        this.bucketsOnly = buckets;
    }

    public static PartitionMessage.PartitionResponse send(Set recipients, PartitionedRegion r, boolean validateOnly, boolean onlyBuckets) {
        PartitionMessage.PartitionResponse p = new PartitionMessage.PartitionResponse(r.getSystem(), recipients);
        DumpBucketsMessage m = new DumpBucketsMessage(recipients, r.getPRId(), p, validateOnly, onlyBuckets);
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException {
        PartitionedRegionDataStore ds;
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "DumpBucketsMessage operateOnRegion: {}", pr2.getFullPath());
        }
        if ((ds = pr2.getDataStore()) != null) {
            if (this.bucketsOnly) {
                ds.dumpBuckets();
            } else {
                ds.dumpEntries(this.validateOnly);
            }
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} dumped buckets", this.getClass().getName());
            }
        }
        return true;
    }

    @Override
    public int getDSFID() {
        return 45;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.validateOnly = in.readBoolean();
        this.bucketsOnly = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.validateOnly);
        out.writeBoolean(this.bucketsOnly);
    }
}

