/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.licensing.LicenseChecker;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class DumpB2NRegion
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private boolean onlyReturnPrimaryInfo;

    public DumpB2NRegion() {
    }

    private DumpB2NRegion(Set recipients, int regionId, ReplyProcessor21 processor, int bId, boolean justPrimaryInfo) {
        super(recipients, regionId, processor);
        this.bucketId = bId;
        this.onlyReturnPrimaryInfo = justPrimaryInfo;
    }

    public static DumpB2NResponse send(Set recipients, PartitionedRegion r, int bId, boolean justPrimaryInfo) {
        DumpB2NResponse p = new DumpB2NResponse(r.getSystem(), recipients);
        DumpB2NRegion m = new DumpB2NRegion(recipients, r.getPRId(), p, bId, justPrimaryInfo);
        r.getDistributionManager().putOutgoing(m);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void process(DistributionManager dm) {
        pr = null;
        finish = System.currentTimeMillis() + 10000L;
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                dm.getCancelCriterion().checkCancelInProgress(null);
                pr = PartitionedRegion.getPRFromId(this.regionId);
                if (pr != null) ** break;
                if (System.currentTimeMillis() > finish) {
                    rex = new ReplyException(new TimeoutException("Waited too long for region to initialize"));
                    this.sendReply(this.getSender(), this.processorId, dm, rex, null, 0L);
                    return;
                }
                interrupted = Thread.interrupted();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    pr.checkReadiness();
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            pr.waitForData();
            super.process(dm);
        }
        catch (CancelException e) {
            this.sendReply(this.sender, this.processorId, dm, new ReplyException(e), pr, 0L);
        }
        catch (PRLocallyDestroyedException e) {
            this.sendReply(this.sender, this.processorId, dm, new ReplyException(e), pr, 0L);
            return;
        }
        catch (RegionDestroyedException rde) {
            this.sendReply(this.sender, this.processorId, dm, new ReplyException(rde), pr, 0L);
            return;
        }
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion pr2, long startTime) throws CacheException {
        PrimaryInfo pinfo = null;
        if (this.onlyReturnPrimaryInfo) {
            LicenseChecker lc = pr2.getSystem().getLicenseChecker();
            pinfo = new PrimaryInfo(pr2.getRegionAdvisor().getBucket(this.bucketId).isHosting(), pr2.getRegionAdvisor().isPrimaryForBucket(this.bucketId), lc != null ? lc.getHostToken() : "");
        } else {
            pr2.dumpB2NForBucket(this.bucketId);
        }
        DumpB2NReplyMessage.send(this.getSender(), this.getProcessorId(), dm, pinfo);
        return false;
    }

    @Override
    public int getDSFID() {
        return -98;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.onlyReturnPrimaryInfo = in.readBoolean();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeBoolean(this.onlyReturnPrimaryInfo);
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append(" bucketId=").append(this.bucketId).append(" primaryInfoOnly=").append(this.onlyReturnPrimaryInfo);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private static class PrimaryInfo
    implements Serializable {
        private static final long serialVersionUID = 6334695270795306178L;
        public final boolean isHosting;
        public final boolean isPrimary;
        public final String hostToken;

        PrimaryInfo(boolean isHosting, boolean isPrimary, String hToken) {
            this.isHosting = isHosting;
            this.isPrimary = isPrimary;
            this.hostToken = hToken;
            if (this.isPrimary) {
                Assert.assertTrue(this.isHosting);
            }
        }
    }

    public static class DumpB2NResponse
    extends PartitionMessage.PartitionResponse {
        public final ArrayList primaryInfos = new ArrayList();

        public DumpB2NResponse(InternalDistributedSystem dm, Set initMembers) {
            super(dm, initMembers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof DumpB2NReplyMessage) {
                DumpB2NReplyMessage reply = (DumpB2NReplyMessage)msg;
                if (reply.getPrimaryInfo() != null && reply.getPrimaryInfo().isHosting) {
                    Object[] newBucketHost = new Object[]{reply.getSender(), reply.getPrimaryInfo().isPrimary, reply.getPrimaryInfo().hostToken};
                    ArrayList arrayList = this.primaryInfos;
                    synchronized (arrayList) {
                        this.primaryInfos.add(newBucketHost);
                    }
                }
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DumpB2NResponse got a primaryInfo {} from {}", reply.getPrimaryInfo(), reply.getSender());
                }
            }
            super.process(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List waitForPrimaryInfos() throws ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException e) {
                logger.debug("B2NResponse got ForceReattemptException; rethrowing {}", e.getMessage(), e);
                throw e;
            }
            catch (CacheException e) {
                logger.debug("B2NResponse got remote CacheException, throwing ForceReattemptException. {}", e.getMessage(), e);
                throw new ForceReattemptException(LocalizedStrings.DumpB2NRegion_B2NRESPONSE_GOT_REMOTE_CACHEEXCEPTION_THROWING_FORCEREATTEMPTEXCEPTION.toLocalizedString(), e);
            }
            ArrayList arrayList = this.primaryInfos;
            synchronized (arrayList) {
                return this.primaryInfos;
            }
        }
    }

    public static final class DumpB2NReplyMessage
    extends ReplyMessage {
        private PrimaryInfo primaryInfo;

        public DumpB2NReplyMessage() {
        }

        private DumpB2NReplyMessage(int procid, PrimaryInfo pinfo) {
            this.setProcessorId(procid);
            this.primaryInfo = pinfo;
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, PrimaryInfo pinfo) {
            DumpB2NReplyMessage m = new DumpB2NReplyMessage(processorId, pinfo);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DumpB2NReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DumpB2NReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        public PrimaryInfo getPrimaryInfo() {
            return this.primaryInfo;
        }

        @Override
        public int getDSFID() {
            return -97;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.primaryInfo = (PrimaryInfo)DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.primaryInfo, out);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DumpB2NReplyMessage ");
            sb.append(this.processorId);
            sb.append(" from ");
            sb.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }
    }
}

