/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DeposePrimaryBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile int bucketId;

    public DeposePrimaryBucketMessage() {
    }

    private DeposePrimaryBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
    }

    public static DeposePrimaryBucketResponse send(InternalDistributedMember recipient, PartitionedRegion region, int bucketId) {
        Assert.assertTrue(recipient != null, "DeposePrimaryBucketMessage NULL recipient");
        DeposePrimaryBucketResponse response = new DeposePrimaryBucketResponse(region.getSystem(), recipient, region);
        DeposePrimaryBucketMessage msg = new DeposePrimaryBucketMessage(recipient, region.getPRId(), response, bucketId);
        Set failures = region.getDistributionManager().putOutgoing(msg);
        if (failures != null && failures.size() > 0) {
            return null;
        }
        region.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public DeposePrimaryBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected final boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        BucketAdvisor bucketAdvisor = region.getRegionAdvisor().getBucketAdvisor(this.bucketId);
        bucketAdvisor.deposePrimary();
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        DeposePrimaryBucketReplyMessage.send(this.getSender(), this.getProcessorId(), dm, (ReplyException)null);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 130;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
    }

    public static class DeposePrimaryBucketResponse
    extends PartitionMessage.PartitionResponse {
        public DeposePrimaryBucketResponse(InternalDistributedSystem ds, InternalDistributedMember recipient, PartitionedRegion theRegion) {
            super(ds, recipient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof DeposePrimaryBucketReplyMessage) {
                    DeposePrimaryBucketReplyMessage reply = (DeposePrimaryBucketReplyMessage)msg;
                    if (reply.isSuccess()) {
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.trace(LogMarker.DM, "DeposePrimaryBucketResponse return OK");
                        }
                    } else if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "DeposePrimaryBucketResponse return NOT_PRIMARY");
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("DeposePrimaryBucketMessage ignoring exception {}", ex.getMessage(), ex);
        }
    }

    public static final class DeposePrimaryBucketReplyMessage
    extends ReplyMessage {
        public DeposePrimaryBucketReplyMessage() {
        }

        public DeposePrimaryBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private DeposePrimaryBucketReplyMessage(int processorId, ReplyException re) {
            this.setProcessorId(processorId);
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, DM dm, ReplyException re) {
            Assert.assertTrue(recipient != null, "DeposePrimaryBucketReplyMessage NULL recipient");
            DeposePrimaryBucketReplyMessage m = new DeposePrimaryBucketReplyMessage(processorId, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        boolean isSuccess() {
            return true;
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DeposePrimaryBucketReplyMessage process invoking reply processor with processorId: {}", this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DeposePrimaryBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
        }

        @Override
        public int getDSFID() {
            return 131;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DeposePrimaryBucketReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }
    }
}

