/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.PartitionedRegionStorageException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class CreateBucketMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private int bucketId;
    private int bucketSize;

    public CreateBucketMessage() {
    }

    private CreateBucketMessage(InternalDistributedMember recipient, int regionId, ReplyProcessor21 processor, int bucketId, int bucketSize) {
        super(recipient, regionId, processor);
        this.bucketId = bucketId;
        this.bucketSize = bucketSize;
    }

    public CreateBucketMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public final int getProcessorType() {
        return 77;
    }

    public static NodeResponse send(InternalDistributedMember recipient, PartitionedRegion r, int bucketId, int bucketSize) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "CreateBucketMessage NULL recipient");
        NodeResponse p = new NodeResponse(r.getSystem(), recipient);
        CreateBucketMessage m = new CreateBucketMessage(recipient, r.getPRId(), p, bucketId, bucketSize);
        p.enableSevereAlertProcessing();
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException("Failed sending <" + m + ">");
        }
        return p;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) {
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "CreateBucketMessage operateOnRegion: {}", r.getFullPath());
        }
        if (!r.isInitialized()) {
            CreateBucketReplyMessage.sendResponse(this.getSender(), this.getProcessorId(), dm, null);
            return false;
        }
        String partitionName = null;
        if (r.isFixedPartitionedRegion()) {
            FixedPartitionAttributesImpl fpa = PartitionedRegionHelper.getFixedPartitionAttributesForBucket(r, this.bucketId);
            partitionName = fpa.getPartitionName();
        }
        r.checkReadiness();
        InternalDistributedMember primary = r.getRedundancyProvider().createBucketAtomically(this.bucketId, this.bucketSize, startTime, false, partitionName);
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        CreateBucketReplyMessage.sendResponse(this.getSender(), this.getProcessorId(), dm, primary);
        return false;
    }

    @Override
    public int getDSFID() {
        return -106;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = in.readInt();
        this.bucketSize = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.bucketId);
        out.writeInt(this.bucketSize);
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; bucketId=").append(this.bucketId).append("; bucketSize=").append(this.bucketSize);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public static class NodeResponse
    extends ReplyProcessor21 {
        private volatile CreateBucketReplyMessage msg;

        public NodeResponse(InternalDistributedSystem ds, InternalDistributedMember recipient) {
            super(ds, recipient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof CreateBucketReplyMessage) {
                    CreateBucketReplyMessage reply;
                    this.msg = reply = (CreateBucketReplyMessage)msg;
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.debug("NodeResponse return value is ");
                    }
                } else {
                    Assert.assertTrue(msg instanceof ReplyMessage);
                }
            }
            finally {
                super.process(msg);
            }
        }

        public InternalDistributedMember waitForResponse() throws ForceReattemptException {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof CancelException) {
                    logger.debug("NodeResponse got remote cancellation, throwing PartitionedRegionCommunication Exception {}", t.getMessage(), t);
                    return null;
                }
                if (t instanceof PRLocallyDestroyedException) {
                    logger.debug("NodeResponse got local destroy on the PartitionRegion , throwing ForceReattemptException {}", t.getMessage(), t);
                    return null;
                }
                if (t instanceof ForceReattemptException) {
                    logger.debug("NodeResponse got ForceReattemptException due to local destroy on the PartitionRegion {}", t.getMessage(), t);
                    return null;
                }
                if (t instanceof PartitionedRegionStorageException) {
                    throw new PartitionedRegionStorageException(t.getMessage(), t);
                }
                e.handleAsUnexpected();
            }
            CreateBucketReplyMessage message = this.msg;
            if (message == null) {
                return null;
            }
            return message.primary;
        }
    }

    public static final class CreateBucketReplyMessage
    extends ReplyMessage {
        private InternalDistributedMember primary;

        public CreateBucketReplyMessage() {
        }

        public CreateBucketReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private CreateBucketReplyMessage(int processorId, InternalDistributedMember primary) {
            this.setProcessorId(processorId);
            this.primary = primary;
        }

        public static void sendResponse(InternalDistributedMember recipient, int processorId, DM dm, InternalDistributedMember primary) {
            Assert.assertTrue(recipient != null, "CreateBucketReplyMessage NULL reply message");
            CreateBucketReplyMessage m = new CreateBucketReplyMessage(processorId, primary);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "CreateBucketReplyMessage process invoking reply processor with processorId:" + this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "CreateBucketReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.primary != null);
            if (this.primary != null) {
                InternalDataSerializer.invokeToData(this.primary, out);
            }
        }

        @Override
        public int getDSFID() {
            return -105;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            boolean hasPrimary = in.readBoolean();
            if (hasPrimary) {
                this.primary = new InternalDistributedMember();
                InternalDataSerializer.invokeFromData(this.primary, in);
            }
        }

        @Override
        public String toString() {
            return new StringBuffer().append("CreateBucketReplyMessage ").append("processorid=").append(this.processorId).toString();
        }
    }
}

