/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache.partitioned;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DirectReplyProcessor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessage;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionMessageWithDirectReply;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class ContainsKeyValueMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private boolean valueCheck;
    private Object key;
    private Integer bucketId;

    public ContainsKeyValueMessage() {
    }

    public ContainsKeyValueMessage(InternalDistributedMember recipient, int regionId, DirectReplyProcessor processor, Object key2, Integer bucketId, boolean valueCheck) {
        super(recipient, regionId, processor);
        this.valueCheck = valueCheck;
        this.key = key2;
        this.bucketId = bucketId;
    }

    public static ContainsKeyValueResponse send(InternalDistributedMember recipient, PartitionedRegion r, Object key2, Integer bucketId, boolean valueCheck) throws ForceReattemptException {
        Assert.assertTrue(recipient != null, "PRDistribuedContainsKeyValueMessage NULL reply message");
        ContainsKeyValueResponse p = new ContainsKeyValueResponse(r.getSystem(), Collections.singleton(recipient), key2);
        ContainsKeyValueMessage m = new ContainsKeyValueMessage(recipient, r.getPRId(), p, key2, bucketId, valueCheck);
        Set failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(LocalizedStrings.ContainsKeyValueMessage_FAILED_SENDING_0.toLocalizedString(m));
        }
        return p;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(DistributionManager dm, PartitionedRegion r, long startTime) throws CacheException, ForceReattemptException {
        boolean replyVal;
        PartitionedRegionDataStore ds = r.getDataStore();
        if (ds != null) {
            try {
                if (r.keyRequiresRegionContext()) {
                    ((KeyWithRegionContext)this.key).setRegionContext(r);
                }
                if (this.valueCheck) {
                    replyVal = ds.containsValueForKeyLocally(this.bucketId, this.key);
                }
                replyVal = ds.containsKeyLocally(this.bucketId, this.key);
            }
            catch (PRLocallyDestroyedException pde) {
                throw new ForceReattemptException(LocalizedStrings.ContainsKeyValueMessage_ENOUNTERED_PRLOCALLYDESTROYEDEXCEPTION.toLocalizedString(), pde);
            }
        } else {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.ContainsKeyValueMess_PARTITIONED_REGION_0_IS_NOT_CONFIGURED_TO_STORE_DATA, r.getFullPath()));
            ForceReattemptException fre = new ForceReattemptException(LocalizedStrings.ContainsKeyValueMessage_PARTITIONED_REGION_0_ON_1_IS_NOT_CONFIGURED_TO_STORE_DATA.toLocalizedString(r.getFullPath(), dm.getId()));
            fre.setHash(this.key.hashCode());
            throw fre;
        }
        r.getPrStats().endPartitionMessagesProcessing(startTime);
        ContainsKeyValueReplyMessage.send(this.getSender(), this.getProcessorId(), this.getReplySender(dm), replyVal);
        return false;
    }

    @Override
    protected void appendFields(StringBuffer buff) {
        super.appendFields(buff);
        buff.append("; valueCheck=").append(this.valueCheck).append("; key=").append(this.key).append("; bucketId=").append(this.bucketId);
    }

    @Override
    public int getDSFID() {
        return 43;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.key = DataSerializer.readObject(in);
        this.valueCheck = in.readBoolean();
        this.bucketId = in.readInt();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.key, out);
        out.writeBoolean(this.valueCheck);
        out.writeInt(this.bucketId);
    }

    public static class ContainsKeyValueResponse
    extends PartitionMessage.PartitionResponse {
        private volatile boolean returnValue;
        private volatile boolean returnValueReceived;
        final Object key;

        public ContainsKeyValueResponse(InternalDistributedSystem ds, Set recipients, Object key2) {
            super(ds, recipients, false);
            this.key = key2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            try {
                if (msg instanceof ContainsKeyValueReplyMessage) {
                    ContainsKeyValueReplyMessage reply = (ContainsKeyValueReplyMessage)msg;
                    this.returnValue = reply.doesItContainKeyValue();
                    this.returnValueReceived = true;
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "ContainsKeyValueResponse return value is {}", this.returnValue);
                    }
                }
            }
            finally {
                super.process(msg);
            }
        }

        public boolean waitForContainsResult() throws PrimaryBucketException, ForceReattemptException {
            try {
                this.waitForCacheException();
            }
            catch (ForceReattemptException rce) {
                rce.checkKey(this.key);
                throw rce;
            }
            catch (PrimaryBucketException pbe) {
                throw pbe;
            }
            catch (CacheException ce) {
                logger.debug("ContainsKeyValueResponse got remote CacheException; forcing reattempt. {}", ce.getMessage(), ce);
                throw new ForceReattemptException(LocalizedStrings.ContainsKeyValueMessage_CONTAINSKEYVALUERESPONSE_GOT_REMOTE_CACHEEXCEPTION_FORCING_REATTEMPT.toLocalizedString(), ce);
            }
            if (!this.returnValueReceived) {
                throw new ForceReattemptException(LocalizedStrings.ContainsKeyValueMessage_NO_RETURN_VALUE_RECEIVED.toLocalizedString());
            }
            return this.returnValue;
        }
    }

    public static final class ContainsKeyValueReplyMessage
    extends ReplyMessage {
        private boolean containsKeyValue;

        public ContainsKeyValueReplyMessage() {
        }

        private ContainsKeyValueReplyMessage(int processorId, boolean containsKeyValue) {
            this.processorId = processorId;
            this.containsKeyValue = containsKeyValue;
        }

        public static void send(InternalDistributedMember recipient, int processorId, ReplySender replySender, boolean containsKeyValue) {
            Assert.assertTrue(recipient != null, "ContainsKeyValueReplyMessage NULL reply message");
            ContainsKeyValueReplyMessage m = new ContainsKeyValueReplyMessage(processorId, containsKeyValue);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "ContainsKeyValueReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "{} Processed {}", processor, this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public int getDSFID() {
            return 64;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.containsKeyValue = in.readBoolean();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeBoolean(this.containsKeyValue);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("ContainsKeyValueReplyMessage ").append("processorid=").append(this.processorId).append(" returning ").append(this.doesItContainKeyValue());
            return sb.toString();
        }

        public boolean doesItContainKeyValue() {
            return this.containsKeyValue;
        }
    }
}

